/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.registry;

import de.fraunhofer.iese.ind2uce.api.component.description.InputParameterDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import de.fraunhofer.iese.ind2uce.registry.ComponentType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

class InterfaceDescriptionDiscovery {
    InterfaceDescriptionDiscovery() {
    }

    protected MethodInterfaceDescription composeInterfaceDescription(Method method, String prefix, ActionDescription actionDescription, String name) {
        return new MethodInterfaceDescription(prefix + ":" + name, method.getReturnType(), actionDescription.description(), this.readParameter(method));
    }

    private InputParameterDescription createInputParameterDescription(Class parameterType, Annotation[] annotations, int index) {
        ActionParameterDescription annotation = this.getParameterDescriptionAnnotation(annotations);
        if (annotation != null) {
            String parameterName = annotation.name();
            String description = annotation.description();
            parameterType = annotation.type().equals(Void.class) ? parameterType : annotation.type();
            return new InputParameterDescription(parameterName, description, annotation.pattern(), annotation.mandatory(), parameterType);
        }
        if (this.isActionParameterDescriptionNecessary(parameterType, index)) {
            throw new IllegalStateException("Not all parameters are documented.");
        }
        return null;
    }

    protected Map<MethodInterfaceDescription, ? extends Pair<Method, Object>> createInterfaceDescriptionFromServiceMethod(Object service, Method method, String prefix) {
        ActionDescription actionDescription = method.getAnnotation(ActionDescription.class);
        String name = this.readName(method, actionDescription);
        this.readParameter(method);
        return Collections.singletonMap(this.composeInterfaceDescription(method, prefix, actionDescription, name), new ImmutablePair((Object)method, service));
    }

    Map<MethodInterfaceDescription, Pair<Method, Object>> discover(Object service, ComponentType type, EnforcementScopeId enforcementScopeId) {
        String enforcementScope = this.getEnforcementScopeId(enforcementScopeId);
        HashMap<MethodInterfaceDescription, Pair<Method, Object>> toReturn = new HashMap<MethodInterfaceDescription, Pair<Method, Object>>();
        for (Method method : service.getClass().getMethods()) {
            if (!this.isServiceMethod(method)) continue;
            toReturn.putAll(this.createInterfaceDescriptionFromServiceMethod(service, method, type.getPrefixForInterfaceDescription() + enforcementScope));
        }
        return toReturn;
    }

    private String getEnforcementScopeId(EnforcementScopeId enforcementScopeId) {
        return enforcementScopeId.getIdentifier();
    }

    private ActionParameterDescription getParameterDescriptionAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ActionParameterDescription)) continue;
            return (ActionParameterDescription)annotation;
        }
        return null;
    }

    protected boolean isActionParameterDescriptionNecessary(Class parameterType, int index) {
        return true;
    }

    protected boolean isServiceMethod(Method method) {
        return method.isAnnotationPresent(ActionDescription.class);
    }

    private String readName(Method method, ActionDescription actionDescription) {
        return StringUtils.isNotBlank((String)actionDescription.methodName()) ? actionDescription.methodName() : method.getName();
    }

    private List<InputParameterDescription> readParameter(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<InputParameterDescription> toReturn = new ArrayList<InputParameterDescription>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            InputParameterDescription inputParameterDescription = this.createInputParameterDescription(parameters[i], parameterAnnotations[i], i);
            if (inputParameterDescription == null) continue;
            toReturn.add(inputParameterDescription);
        }
        return toReturn;
    }
}

