/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.reactive;

import de.fraunhofer.iese.ind2uce.api.component.description.InputParameterDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.ModifierInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.PepInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.policy.AuthorizationDecision;
import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import de.fraunhofer.iese.ind2uce.connectors.OAuthCredentials;
import de.fraunhofer.iese.ind2uce.json.schema.JsonSchemaGenerator;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.pep.PolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.pep.common.DecisionEnforcer;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.pep.enforce.JsonPathDecisionEnforcer;
import de.fraunhofer.iese.ind2uce.reactive.ReactivePEP;
import de.fraunhofer.iese.ind2uce.reactive.common.EventParameter;
import de.fraunhofer.iese.ind2uce.reactive.common.EventSpecification;
import de.fraunhofer.iese.ind2uce.reactive.common.IncorrectPEPDescriptionError;
import de.fraunhofer.iese.ind2uce.reactive.common.PEPServiceDescription;
import de.fraunhofer.iese.ind2uce.reactive.common.PEPType;
import de.fraunhofer.iese.ind2uce.reactive.common.ProvidedModifiers;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import rx.Observable;

public class RxPEPFactory {
    protected static Logger LOG = LoggerFactory.getLogger(PolicyEnforcementPoint.class);

    public static <T> ReactivePEP<T> createRxPEP(Class<T> pepDocumentationApi, URI pmpUri, DecisionEnforcer decisionEnforcer, URI aliveCheckUri, OAuthCredentials credentials) {
        RxPEPFactory.validateDocumentationApi(pepDocumentationApi);
        RxPEPFactory.validateMethodReturnType(pepDocumentationApi);
        Collection<ModifierMethod> allModifierMethods = RxPEPFactory.getAllModifierActor(pepDocumentationApi);
        try {
            allModifierMethods.forEach(modifierActor -> decisionEnforcer.addModificationMethod((ModifierMethod)modifierActor));
        }
        catch (Exception e) {
            LOG.error("Error while adding modifiers");
            throw new IncorrectPEPDescriptionError("Unknown PEP creation error happened!" + e.getMessage());
        }
        try {
            PolicyEnforcementPoint policyEnforcementPoint = new PolicyEnforcementPoint(decisionEnforcer, RxPEPFactory.getComponentId(pepDocumentationApi), pmpUri, RxPEPFactory.discoverPEPDocumentationApi(pepDocumentationApi), RxPEPFactory.discoverModifierInterfaceDescription(pepDocumentationApi), aliveCheckUri, false, credentials);
            return new ReactivePEP<T>(pepDocumentationApi, policyEnforcementPoint);
        }
        catch (IOException io) {
            LOG.error("IOException must not happen!");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Reactive PEP is not created: documentation API not found");
            throw new IncorrectPEPDescriptionError("PEP not created because of some classloading issue", e);
        }
        throw new IncorrectPEPDescriptionError("Unknown PEP creation error happened!");
    }

    public static <T> ReactivePEP<T> createRxPEP(Class<T> pepDocumentationApi, URI pmpUri, URI aliveCheckUri, OAuthCredentials oauthClientCredentials) {
        JsonPathDecisionEnforcer jvmNativeDecisionEnforcer = new JsonPathDecisionEnforcer();
        return RxPEPFactory.createRxPEP(pepDocumentationApi, pmpUri, jvmNativeDecisionEnforcer, aliveCheckUri, oauthClientCredentials);
    }

    private static InputParameterDescription createInputParameterDescription(Class parameterType, Annotation[] annotations) {
        ActionParameterDescription annotation = RxPEPFactory.getParameterDescriptionAnnotation(annotations);
        if (annotation != null) {
            String parameterName = annotation.name();
            String description = annotation.description();
            parameterType = annotation.type().equals(Void.class) ? parameterType : annotation.type();
            return new InputParameterDescription(parameterName, description, annotation.pattern(), annotation.mandatory(), parameterType);
        }
        return null;
    }

    private static final <T> List<ModifierInterfaceDescription> discoverModifierInterfaceDescription(Class<T> tClass) {
        LinkedList<ModifierInterfaceDescription> modifierInterfaceDescriptions = new LinkedList<ModifierInterfaceDescription>();
        Annotation[] requiredModifier = tClass.getAnnotationsByType(ProvidedModifiers.class);
        if (requiredModifier.length > 0) {
            Class<? extends ModifierMethod>[] modifierClasses;
            for (Class<? extends ModifierMethod> modifierClass : modifierClasses = ((ProvidedModifiers)requiredModifier[0]).className()) {
                Method[] modifierMethods;
                for (Method modifierMethod : modifierMethods = modifierClass.getDeclaredMethods()) {
                    if (!modifierMethod.isAnnotationPresent(ActionDescription.class)) continue;
                    ActionDescription actionDescription = modifierMethod.getAnnotation(ActionDescription.class);
                    String modifierName = RxPEPFactory.readName(modifierMethod, actionDescription);
                    List<InputParameterDescription> modifierInputParameter = RxPEPFactory.readModifierParameter(modifierMethod);
                    Class returnType = actionDescription.pepSupportedType();
                    String modifierDescription = actionDescription.description();
                    modifierInterfaceDescriptions.add(new ModifierInterfaceDescription(modifierName, returnType, modifierDescription, returnType.getTypeName(), modifierInputParameter));
                }
            }
        }
        return modifierInterfaceDescriptions;
    }

    private static final <T> List<PepInterfaceDescription> discoverPEPDocumentationApi(Class<T> pepDocumentationApi) throws ClassNotFoundException {
        Method[] methods = pepDocumentationApi.getDeclaredMethods();
        LinkedList<PepInterfaceDescription> interfaceDescriptions = new LinkedList<PepInterfaceDescription>();
        for (Method method : methods) {
            Annotation[] eventDescriptionAnnotations = method.getAnnotationsByType(EventSpecification.class);
            if (eventDescriptionAnnotations.length == 0) continue;
            EventSpecification eventDescriptionForMethod = (EventSpecification)eventDescriptionAnnotations[0];
            ActionId actionId = new ActionId(eventDescriptionForMethod.scope(), eventDescriptionForMethod.action());
            PepInterfaceDescription pepInterfaceDescription = new PepInterfaceDescription(actionId, true, eventDescriptionForMethod.description());
            pepInterfaceDescription.setEventParameterDescription(RxPEPFactory.readEventParameterDetails(method));
            interfaceDescriptions.add(pepInterfaceDescription);
        }
        return interfaceDescriptions;
    }

    private static <T> T filter(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }

    public static <T> PEPType findAPIDocumentationType(Class<T> pepDocumentationApi) {
        if (((Boolean)RxPEPFactory.isValidDocumentation(pepDocumentationApi).getKey()).booleanValue()) {
            return PEPType.REACTIVE;
        }
        return PEPType.INVALID;
    }

    private static final <T> Collection<ModifierMethod> getAllModifierActor(Class<T> pepDocumentationApi) {
        Map<String, ModifierMethod> toReturn = RxPEPFactory.readModifierNewInstanceFromApiDocumentation(pepDocumentationApi);
        Annotation[] requiredModifier = pepDocumentationApi.getAnnotationsByType(ProvidedModifiers.class);
        if (requiredModifier.length > 0) {
            Class<? extends ModifierMethod>[] modifierActors;
            for (Class<? extends ModifierMethod> modifierActor : modifierActors = ((ProvidedModifiers)requiredModifier[0]).className()) {
                if (toReturn.containsKey(modifierActor.getCanonicalName())) continue;
                try {
                    toReturn.put(modifierActor.getCanonicalName(), modifierActor.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IncorrectPEPDescriptionError(modifierActor.getCanonicalName() + "does not have default contractor nor supplied with static method in PEP API documentation interface");
                }
            }
        }
        return toReturn.values();
    }

    private static final <T> ComponentId getComponentId(Class<T> pepDocumentationApi) {
        Annotation[] classAnnotations = pepDocumentationApi.getAnnotationsByType(PEPServiceDescription.class);
        String componentIdStr = ((PEPServiceDescription)classAnnotations[0]).componentId();
        ComponentId componentId = new ComponentId(componentIdStr);
        return componentId;
    }

    private static ActionParameterDescription getParameterDescriptionAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ActionParameterDescription)) continue;
            return (ActionParameterDescription)annotation;
        }
        return null;
    }

    public static <T> Pair<Boolean, RuntimeException> isValidDocumentation(Class<T> pepDocumentationApi) {
        Method[] pepDocumentationApiMethods;
        for (Method pepDocumentationApiMethod : pepDocumentationApiMethods = pepDocumentationApi.getDeclaredMethods()) {
            if (Modifier.isStatic(pepDocumentationApiMethod.getModifiers())) continue;
            Type returnType = pepDocumentationApiMethod.getGenericReturnType();
            if (pepDocumentationApiMethod.getReturnType() == Observable.class && returnType instanceof ParameterizedType && pepDocumentationApiMethod.isAnnotationPresent(EventSpecification.class)) {
                Type[] observableType = ((ParameterizedType)returnType).getActualTypeArguments();
                if (observableType[0] == Event.class || observableType[0] instanceof ParameterizedType && ((ParameterizedType)observableType[0]).getRawType() == Pair.class && ((ParameterizedType)observableType[0]).getActualTypeArguments().length == 2 && ((ParameterizedType)observableType[0]).getActualTypeArguments()[0] == Event.class && ((ParameterizedType)observableType[0]).getActualTypeArguments()[1] == AuthorizationDecision.class) continue;
                return new ImmutablePair((Object)false, (Object)new IncorrectPEPDescriptionError("Observable only can have Event or Pair<Event,AuthorizationDecision>"));
            }
            return new ImmutablePair((Object)false, (Object)new IncorrectPEPDescriptionError("PEP can't have void/anything else method, All methods should return ModifierMethod or Observable"));
        }
        return new ImmutablePair((Object)true, null);
    }

    private static List<InputParameterDescription> readEventParameterDetails(Method method) throws ClassNotFoundException {
        LinkedList<InputParameterDescription> inputParameterDescriptions = new LinkedList<InputParameterDescription>();
        Parameter[] parameters = method.getParameters();
        Annotation[][] annotation = method.getParameterAnnotations();
        for (int i = 0; i < annotation.length; ++i) {
            EventParameter pepParamKey = RxPEPFactory.filter(annotation[i], EventParameter.class);
            if (pepParamKey == null) continue;
            inputParameterDescriptions.add(new InputParameterDescription(pepParamKey.name(), pepParamKey.description(), null, true, parameters[i].getParameterizedType(), JsonSchemaGenerator.getJsonType(parameters[i].getType()), JsonSchemaGenerator.createTypeDescription(parameters[i].getParameterizedType(), parameters[i].getType())));
        }
        return inputParameterDescriptions;
    }

    private static final <T> Map<String, ModifierMethod> readModifierNewInstanceFromApiDocumentation(Class<T> pepDocumentationApi) {
        Method[] allMethod = pepDocumentationApi.getDeclaredMethods();
        HashMap<String, ModifierMethod> toReturn = new HashMap<String, ModifierMethod>();
        for (Method method : allMethod) {
            if (!Modifier.isStatic(method.getModifiers()) || !ModifierMethod.class.isAssignableFrom(method.getReturnType())) continue;
            try {
                ModifierMethod modifierActor = (ModifierMethod)method.invoke(null, new Object[0]);
                toReturn.put(method.getReturnType().getCanonicalName(), modifierActor);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IncorrectPEPDescriptionError("method to supply ModifierActor should not have any arguments.");
            }
        }
        return toReturn;
    }

    private static List<InputParameterDescription> readModifierParameter(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<InputParameterDescription> toReturn = new ArrayList<InputParameterDescription>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            InputParameterDescription inputParameterDescription = RxPEPFactory.createInputParameterDescription(parameters[i], parameterAnnotations[i]);
            if (inputParameterDescription == null) continue;
            toReturn.add(inputParameterDescription);
        }
        return toReturn;
    }

    private static String readName(Method method, ActionDescription actionDescription) {
        return StringUtils.isNotBlank((String)actionDescription.methodName()) ? actionDescription.methodName() : method.getName();
    }

    private static <T> void validateDocumentationApi(Class<T> pepDocumentationApi) {
        if (!pepDocumentationApi.isInterface()) {
            throw new IllegalArgumentException("Reactive PEP API documentation must be interfaces.");
        }
        if (pepDocumentationApi.getInterfaces().length > 0) {
            throw new IllegalArgumentException("Reactive PEP API documentation interfaces must not extend other interfaces.");
        }
    }

    private static <T> void validateMethodReturnType(Class<T> pepDocumentationApi) {
        Pair<Boolean, RuntimeException> booleanRuntimeExceptionPair = RxPEPFactory.isValidDocumentation(pepDocumentationApi);
        if (!((Boolean)booleanRuntimeExceptionPair.getKey()).booleanValue()) {
            throw (RuntimeException)booleanRuntimeExceptionPair.getValue();
        }
    }
}

