/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.reactive;

import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.pep.PolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.reactive.common.EventParameter;
import de.fraunhofer.iese.ind2uce.reactive.common.EventSpecification;
import de.fraunhofer.iese.ind2uce.reactive.common.EventUUID;
import de.fraunhofer.iese.ind2uce.reactive.common.IncorrectPEPDescriptionError;
import de.fraunhofer.iese.ind2uce.reactive.common.RxPEP;
import de.fraunhofer.iese.ind2uce.reactive.common.RxPEPState;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import rx.Observable;
import rx.schedulers.Schedulers;

public abstract class AbstractRxPEP<T>
implements RxPEP<T> {
    protected static Logger LOG = LoggerFactory.getLogger(PolicyEnforcementPoint.class);
    protected final AtomicReference<RxPEPState> pepState = new AtomicReference<RxPEPState>(RxPEPState.REGISTRATION_NOT_STARTED);
    protected final IPolicyEnforcementPoint policyEnforcementPoint;
    protected final Class<T> pepInterfaceDescription;

    public AbstractRxPEP(IPolicyEnforcementPoint policyEnforcementPoint, Class<T> pepInterfaceDescription) {
        this.policyEnforcementPoint = policyEnforcementPoint;
        this.pepInterfaceDescription = pepInterfaceDescription;
    }

    @Override
    public T createInstanceAPI() {
        if (this.pepState.get() == RxPEPState.REGISTRATION_DONE_SUCCESSFULLY) {
            return (T)Proxy.newProxyInstance(this.pepInterfaceDescription.getClassLoader(), new Class[]{this.pepInterfaceDescription}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getDeclaringClass() == Object.class) {
                        return method.invoke((Object)this, args);
                    }
                    return AbstractRxPEP.this.enforceDecision(method, args);
                }
            });
        }
        throw new IllegalStateException("RxPEP is not registered yet, please perform successful registration before using documentation API");
    }

    @Override
    public Observable<Boolean> doRegisterAtPMP() {
        return Observable.fromCallable(() -> {
            switch (this.pepState.get()) {
                case REGISTRATION_DONE_SUCCESSFULLY: {
                    return false;
                }
                case REGISTRATION_FAILED: {
                    return false;
                }
                case REGISTRATION_NOT_STARTED: {
                    this.pepState.set(RxPEPState.REGISTRATION_UNDER_PROCESS);
                    return this.policyEnforcementPoint.initialize(new String[0]);
                }
                case REGISTRATION_UNDER_PROCESS: {
                    throw new IllegalStateException("PEP under registration, don't try to register when it's already under the process");
                }
            }
            throw new IllegalStateException("WTF state");
        }).doOnError(e -> {
            if (e instanceof IOException) {
                LOG.error("Registration of PEP at PMP failed!");
                this.pepState.set(RxPEPState.REGISTRATION_FAILED);
            }
        }).doOnNext(aBoolean -> {
            if (this.pepState.get() != RxPEPState.REGISTRATION_DONE_SUCCESSFULLY) {
                if (aBoolean.booleanValue()) {
                    this.pepState.set(RxPEPState.REGISTRATION_DONE_SUCCESSFULLY);
                    this.postSuccessfulRegistration();
                } else {
                    this.pepState.set(RxPEPState.REGISTRATION_FAILED);
                }
            }
        }).subscribeOn(Schedulers.immediate());
    }

    protected abstract Object enforceDecision(Method var1, Object[] var2);

    EventParameter getParameterAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof EventParameter)) continue;
            return (EventParameter)annotation;
        }
        return null;
    }

    @Override
    public IPolicyEnforcementPoint getPolicyEnforcementPoint() {
        return this.policyEnforcementPoint;
    }

    @Override
    public RxPEPState isReady() {
        return this.pepState.get();
    }

    protected abstract void postSuccessfulRegistration();

    protected Event readAndCreateEvent(Method method, Object[] methodArguments) throws IncorrectPEPDescriptionError {
        ActionId actionId = this.readEventDescription(method);
        Event event = new Event(actionId, new Parameter[0]);
        event.setTag(this.readUUID(method, methodArguments));
        event.setParameters(this.readParameterList(method.getParameterTypes(), method.getParameterAnnotations(), methodArguments));
        return event;
    }

    protected ActionId readEventDescription(Method method) {
        Annotation[] methodAnnotation = method.getDeclaredAnnotationsByType(EventSpecification.class);
        if (methodAnnotation.length > 0) {
            ActionId eventId = null;
            EventSpecification ed = (EventSpecification)methodAnnotation[0];
            eventId = new ActionId(ed.scope(), ed.action());
            return eventId;
        }
        LOG.error("API declaration error: ActionId can't be null for event.");
        throw new IncorrectPEPDescriptionError("ActionId can't be null for event. API declaration error");
    }

    protected ParameterList readParameterList(Class<?>[] parametersType, Annotation[][] parametersAnnotations, Object[] methodArguments) {
        ParameterList parameters = new ParameterList();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            EventParameter PEPParamKey = this.getParameterAnnotation(parametersAnnotations[i]);
            if (PEPParamKey == null) continue;
            parameters.addParameter(PEPParamKey.name(), methodArguments[i], parametersType[i]);
        }
        return parameters;
    }

    private Object readUUID(Method method, Object[] methodArguments) {
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (((EventUUID[])parameters[i].getAnnotationsByType(EventUUID.class)).length == 0) continue;
            return methodArguments[i];
        }
        return null;
    }
}

