/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Predicate;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

public class AppendModifierMethod
implements ModifierMethod {
    private static final String name = "append";

    @ActionDescription(description="Appends a prefix and/or suffix to an event parameter value", pepSupportedType=String.class)
    public DocumentContext append(DocumentContext documentContext, String expression, @ActionParameterDescription(name="suffix", description="String to append at the end", mandatory=false, type=String.class) String suffix, @ActionParameterDescription(name="prefix", description="String to append at the head", mandatory=false, type=String.class) String prefix) {
        MapFunction append = (currentValue, configuration) -> {
            StringBuilder builder = new StringBuilder();
            if (prefix != null) {
                builder.append(prefix);
            }
            builder.append(currentValue.toString());
            if (suffix != null) {
                builder.append(suffix);
            }
            return builder.toString();
        };
        return documentContext.map(expression, append, new Predicate[0]);
    }

    @Override
    public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
        Object suffix = modifierMethodParameterList.getParameterValueForName("suffix");
        String suffixParam = suffix != null ? suffix.toString() : null;
        Object prefix = modifierMethodParameterList.getParameterValueForName("prefix");
        String prefixParam = prefix != null ? prefix.toString() : null;
        return this.append(documentContext, expression, suffixParam, prefixParam);
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object suffix = modifierMethodParameterList.getParameterValueForName("suffix");
        String suffixParam = suffix != null ? suffix.toString() : null;
        Object prefix = modifierMethodParameterList.getParameterValueForName("prefix");
        String prefixParam = prefix != null ? prefix.toString() : null;
        StringBuilder builder = new StringBuilder();
        if (prefixParam != null) {
            builder.append(prefixParam);
        }
        builder.append(currentObject.toString());
        if (suffixParam != null) {
            builder.append(suffixParam);
        }
        return builder.toString();
    }

    @Override
    public String getDisplayName() {
        return name;
    }
}

