/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Predicate;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import java.util.Random;
import org.slf4j.Logger;

public class AnagramModifierMethod
implements ModifierMethod {
    protected static Logger LOG = LoggerFactory.getLogger(AnagramModifierMethod.class);

    @ActionDescription(description="Jumbles up the letters of the word so string does not make any sense", pepSupportedType=String.class)
    public DocumentContext anagram(DocumentContext documentContext, String expression, @ActionParameterDescription(name="percentage", description="percentage of String to be modified (value between 0 and 100)", mandatory=true, type=Integer.class) int percentage) {
        MapFunction blur = (o, configuration) -> this.scramble(o.toString(), percentage);
        return documentContext.map(expression, blur, new Predicate[0]);
    }

    @Override
    public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
        Object percentage = modifierMethodParameterList.getParameterValueForName("percentage");
        int percentageParam = percentage != null ? Integer.parseInt(String.valueOf(percentage)) : 0;
        return this.anagram(documentContext, expression, percentageParam);
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        if (currentObject instanceof String) {
            Object percentage = modifierMethodParameterList.getParameterValueForName("percentage");
            int percentageParam = percentage != null ? Integer.parseInt(String.valueOf(percentage)) : 0;
            return this.scramble(currentObject.toString(), percentageParam);
        }
        LOG.debug("Unable to build anagram for object of class {}", currentObject.getClass());
        return null;
    }

    @Override
    public String getDisplayName() {
        return "anagram";
    }

    protected String scramble(String inputString, int count) {
        Random random = new Random();
        char[] a = inputString.toCharArray();
        int limit = Math.round((float)a.length * ((float)Math.min(count, 100) / 100.0f));
        for (int i = 0; i < Math.min(a.length - 1, limit); ++i) {
            int j = random.nextInt(Math.min(a.length - 1, limit));
            char temp = a[i];
            a[i] = a[j];
            a[j] = temp;
        }
        String result = new String(a);
        LOG.trace("Built anagram {}% of {} --> {}", new Object[]{count, inputString, result});
        return result;
    }
}

