/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.enforce;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import de.fraunhofer.iese.ind2uce.api.component.exception.InhibitException;
import de.fraunhofer.iese.ind2uce.api.policy.AuthorizationDecision;
import de.fraunhofer.iese.ind2uce.api.policy.Modifier;
import de.fraunhofer.iese.ind2uce.api.policy.ModifierEngine;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ModifierList;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.pep.common.DecisionEnforcer;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierNotFoundException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;

public class JsonPathDecisionEnforcer
implements DecisionEnforcer {
    protected static Logger LOG = LoggerFactory.getLogger(JsonPathDecisionEnforcer.class);
    private static Configuration configuration = new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new GsonJsonProvider()).mappingProvider((MappingProvider)new GsonMappingProvider()).build();
    private final Map<String, ModifierMethod> modifiers = new TreeMap<String, ModifierMethod>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public boolean addModificationMethod(ModifierMethod method) {
        if (this.modifiers != null) {
            this.modifiers.put(method.getDisplayName(), method);
            LOG.info("Modifier is added to the list of modifiers: {}", (Object)method.getDisplayName());
            return true;
        }
        return false;
    }

    private void doModificationForParameter(ParameterList parameterList, Modifier eventParameter) throws InhibitException {
        Parameter parameterForName = parameterList.getParameterForName(eventParameter.getName());
        if (parameterForName != null) {
            LOG.debug("Starting with event modification.");
            this.doModificationForParameter(parameterList, eventParameter, parameterForName);
        }
    }

    private void doModificationForParameter(ParameterList parameterList, Modifier eventParameter, Parameter<?> parameterForName) throws InhibitException {
        Object parameterValue = parameterForName.getValue();
        Class parameterType = parameterForName.getType();
        DocumentContext parameterValueDocumentContext = JsonPath.parse((String)this.gson.toJson(parameterValue), (Configuration)configuration);
        List modifierEngines = eventParameter.getEngine();
        Object modifiedObject = null;
        for (ModifierEngine modifierEngine : modifierEngines) {
            ModifierMethod modifierMethod = this.modifiers.get(modifierEngine.getMethod());
            if (modifierMethod == null) {
                LOG.error("Not found modifier: {}", (Object)modifierEngine.getMethod());
                throw new ModifierNotFoundException("ModificationActor is not registered against Modifier Method named  : " + modifierEngine.getMethod());
            }
            if (eventParameter.getExpression() == null) {
                if (!parameterValue.getClass().isPrimitive() && parameterValue.getClass() != String.class) continue;
                modifiedObject = parameterValue = modifierMethod.doModification(parameterValue, modifierEngine.getParameters());
                continue;
            }
            try {
                parameterValueDocumentContext = modifierMethod.doModification(parameterValueDocumentContext, eventParameter.getExpression(), modifierEngine.getParameters());
                String jsonString = parameterValueDocumentContext.jsonString();
                modifiedObject = this.gson.fromJson(jsonString, (Type)parameterType);
            }
            catch (Exception e) {
                LOG.error("event is inhibited. Error on modification of the modifier: {}", (Object)modifierEngine.getMethod());
                throw new InhibitException("Not able todo modification due to ", (Throwable)e);
            }
        }
        parameterList.removeParameter(eventParameter.getName());
        parameterList.addParameter(eventParameter.getName(), modifiedObject, (Type)parameterType);
    }

    @Override
    public ParameterList enforce(AuthorizationDecision authorizationDecision, ParameterList parameterList) throws InhibitException {
        ModifierList modifiers = authorizationDecision.getModifiers();
        if (modifiers == null || modifiers.isEmpty()) {
            LOG.info("Event does not need to be modified");
            return parameterList;
        }
        LOG.info("Event needs modification");
        for (Modifier eventParameter : modifiers) {
            this.doModificationForParameter(parameterList, eventParameter);
        }
        return parameterList;
    }

    @Override
    public boolean removeModificationMethod(String name) {
        if (this.modifiers != null) {
            this.modifiers.remove(this.modifiers.get(name));
            return true;
        }
        return false;
    }
}

