/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep;

import de.fraunhofer.iese.ind2uce.api.component.Component;
import de.fraunhofer.iese.ind2uce.api.component.exception.EvaluationUndecidableException;
import de.fraunhofer.iese.ind2uce.api.component.exception.InhibitException;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyDecisionPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyManagementPoint;
import de.fraunhofer.iese.ind2uce.api.policy.AuthorizationDecision;
import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.connectors.ConnectorFactory;
import de.fraunhofer.iese.ind2uce.connectors.OAuthCredentials;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.pep.PolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.pep.common.DecisionEnforcer;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;

public class DefaultPolicyEnforcementPoint
implements IPolicyEnforcementPoint {
    protected static Logger LOG = LoggerFactory.getLogger(PolicyEnforcementPoint.class);
    private final transient DecisionEnforcer decisionEnforcer;
    protected final OAuthCredentials oauthClientCredentials;
    protected URI pmpUrl;
    private IPolicyDecisionPoint remotePDP;

    public DefaultPolicyEnforcementPoint(URI pmpUrl, DecisionEnforcer decisionEnforcer, OAuthCredentials oauthClientCredentials) {
        this.pmpUrl = pmpUrl;
        this.decisionEnforcer = decisionEnforcer;
        this.oauthClientCredentials = oauthClientCredentials;
    }

    public boolean assurePDP() throws IOException {
        return this.remotePDP != null || this.initPpdConnection() != null;
    }

    public void enforce(Event event) throws EvaluationUndecidableException, InhibitException, IOException, ModifierNotFoundException {
        LOG.info("Received event for enforcement: {}", (Object)event);
        if (this.assurePDP()) {
            LOG.debug("Requesting decision");
            AuthorizationDecision authorizationDecision = this.remotePDP.decisionRequest(event);
            LOG.debug("Received decision: {}", (Object)authorizationDecision);
            this.enforceDecision(event, authorizationDecision);
        }
    }

    public void enforceDecision(Event event, AuthorizationDecision authorizationDecision) throws InhibitException {
        if (!authorizationDecision.isEventAllowed()) {
            LOG.info("Event will be inhibited");
            event.clearParameters();
            throw new InhibitException("Event is not allowed according to policy");
        }
        LOG.info("Event will be allowed");
        this.decisionEnforcer.enforce(authorizationDecision, event.getParameters());
    }

    public AuthorizationDecision getDecision(Event event) throws EvaluationUndecidableException, IOException {
        LOG.info("Event is going to PDP for Authorization Decision");
        if (this.assurePDP()) {
            return this.remotePDP.decisionRequest(event);
        }
        return null;
    }

    public ComponentId getId() throws IOException {
        return null;
    }

    public boolean initialize(String ... strings) throws IOException {
        return this.initPpdConnection() != null;
    }

    public IPolicyDecisionPoint initPpdConnection() throws IOException {
        IPolicyManagementPoint pmp = ConnectorFactory.getPmpClient((URI)this.pmpUrl, (OAuthCredentials)this.oauthClientCredentials);
        if (pmp == null) {
            LOG.error("PMP is found null");
            throw new IOException("PMP is found null");
        }
        Component component = pmp.lookupPdp();
        LOG.info("List of PDP components fetched successfully from database");
        List uris = component.getUrls();
        for (URI uri : uris) {
            if (!uri.getScheme().equals("https") && !uri.getScheme().equals("http")) continue;
            this.remotePDP = ConnectorFactory.getPdp((URI)uri, (OAuthCredentials)this.oauthClientCredentials);
            if (this.remotePDP != null) {
                LOG.debug("Successfully connected to a PDP");
            }
            return this.remotePDP;
        }
        return this.remotePDP;
    }

    public boolean reset() throws IOException {
        return this.initialize(new String[0]);
    }

    public String getHealth() throws IOException {
        return "{\"status\":{\"code\":\"UP\",\"description\":\"\"},\"details\":{}}";
    }
}

