/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.json.schema;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ClassUtils;

public class JavaReflectionUtils {
    public static Field[] getAllFields(Class anyClass) {
        Field[] allField;
        TreeMap<String, Field> stringFieldMap = new TreeMap<String, Field>();
        Class currentClass = anyClass;
        for (Field field : allField = anyClass.getDeclaredFields()) {
            stringFieldMap.put(field.getName(), field);
        }
        while (currentClass.getSuperclass() != Object.class) {
            for (Field field : allField = currentClass.getSuperclass().getDeclaredFields()) {
                stringFieldMap.put(field.getName(), field);
            }
            currentClass = currentClass.getSuperclass();
        }
        return stringFieldMap.values().toArray(new Field[stringFieldMap.size()]);
    }

    public static boolean isInd2ucePrimitive(Class aClass) {
        return ClassUtils.isPrimitiveOrWrapper((Class)aClass) || aClass.isEnum() || aClass == String.class || aClass == Date.class;
    }

    public static boolean isIterable(Class aClass) {
        return TypeToken.of((Class)aClass).isSubtypeOf(Iterable.class);
    }

    public static boolean isMap(Class aClass) {
        return TypeToken.of((Class)aClass).isSubtypeOf(Map.class);
    }
}

