/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.DocumentContext;

/***
 * This a default Modifier method with PEP sdk which replaces a string with
 * another one where event parameter is either a Json Object or string
 * (primitive type)
 */
public class ReplaceModifierMethod implements ModifierMethod {

  @Override
  public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
    final String replaceWith = (String)modifierMethodParameterList.getParameterValueForName("replaceWith");
    return this.replace(documentContext, expression, replaceWith);
  }

  /***
   * This method works with String type
   *
   * @param currentObject object to be replaced by
   * @param modifierMethodParameterList list of parameter associated with
   * @return modified object
   */
  @Override
  public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
    if (currentObject instanceof String) {
      final String replaceWith = (String)modifierMethodParameterList.getParameterValueForName("replaceWith");
      return replaceWith;
    }
    return null;
  }

  @Override
  public String getDisplayName() {
    return "replace";
  }

  @ActionDescription(description = "Replaces the string", pepSupportedType = String.class)
  public DocumentContext replace(DocumentContext documentContext, String expression,
      @ActionParameterDescription(name = "replaceWith", description = "Replace the string with entered value", mandatory = true, type = java.lang.String.class) String setWith) {
    final JsonParser jsonParser = new JsonParser();
    try {
      final JsonElement jsonElement = jsonParser.parse(setWith);
      return documentContext.set(expression, jsonElement);
    } catch (final Exception e) {
      return documentContext.set(expression, setWith);
    }
  }
}
