/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;

import com.jayway.jsonpath.DocumentContext;

/****
 * This a default Modifier method with PEP sdk which deletes attribute where
 * event parameter is either a Json Object or string (primitive type)
 */
public class DeleteModifierMethod implements ModifierMethod {

  @ActionDescription(description = "Deletes keys that are evaluated by expression", pepSupportedType = Object.class)
  public DocumentContext delete(DocumentContext documentContext, String expression) {
    return documentContext.delete(expression);
  }

  @Override
  public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
    return this.delete(documentContext, expression);
  }

  @Override
  public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
    return null;
  }

  @Override
  public String getDisplayName() {
    return "delete";
  }

}
