/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.MapFunction;

import org.slf4j.Logger;

import java.util.Random;

/****
 * NOTE: This method does not anagram the string as primitive or json . It just
 * jumbles up the letters of the word so string does not make any sense.
 * Implementation is subject to change for later needs. It produces anagram of a
 * given string.
 */
public class AnagramModifierMethod implements ModifierMethod {

  protected static Logger LOG = LoggerFactory.getLogger(AnagramModifierMethod.class);

  @ActionDescription(description = "Jumbles up the letters of the word so string does not make any sense", pepSupportedType = String.class)
  public DocumentContext anagram(DocumentContext documentContext, String expression,
      @ActionParameterDescription(name = "percentage", description = "percentage of String to be modified (value between 0 and 100)", mandatory = true, type = java.lang.Integer.class) int percentage) {
    final MapFunction blur = (o, configuration) -> this.scramble(o.toString(), percentage);
    return documentContext.map(expression, blur);
  }

  @Override
  public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
    final Object percentage = modifierMethodParameterList.getParameterValueForName("percentage");
    final int percentageParam = percentage != null ? Integer.parseInt(String.valueOf(percentage)) : 0;
    return this.anagram(documentContext, expression, percentageParam);
  }

  @Override
  public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
    if (currentObject instanceof String) {
      final Object percentage = modifierMethodParameterList.getParameterValueForName("percentage");
      final int percentageParam = percentage != null ? Integer.parseInt(String.valueOf(percentage)) : 0;
      return this.scramble(currentObject.toString(), percentageParam);
    }
    LOG.debug("Unable to build anagram for object of class {}", currentObject.getClass());
    return null;
  }

  /****
   * @return Display Name
   */
  @Override
  public String getDisplayName() {
    return "anagram";
  }

  /****
   * @param inputString string to scramble
   * @param count count
   * @return Scrambled string
   */
  protected String scramble(String inputString, int count) {
    final Random random = new Random();
    final char a[] = inputString.toCharArray();

    final int limit = Math.round((a.length * (Math.min(count, 100) / 100f)));

    for (int i = 0; i < Math.min(a.length - 1, limit); i++) {
      final int j = random.nextInt(Math.min(a.length - 1, limit));
      final char temp = a[i];
      a[i] = a[j];
      a[j] = temp;
    }
    final String result = new String(a);
    LOG.trace("Built anagram {}% of {} --> {}", count, inputString, result);
    return result;
  }
}
