/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep;

import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;

import java.lang.reflect.Type;

public class EventBuilder {

  private final ActionId actionId;

  private final ParameterList parameterList = new ParameterList();

  private long timeStamp = 0l;

  @Deprecated
  public EventBuilder(String urn) {
    this.actionId = new ActionId(urn);
  }

  /**
   * Instantiates a new event builder for action id given as @param.
   *
   * @param scope Platform part of the id.
   * @param identifier Action Part of the id.
   * @param context context
   */
  public EventBuilder(String scope, String context, String identifier) {
    this.actionId = new ActionId(scope, identifier);
  }

  public EventBuilder withParameter(String key, Object value, Type valueType) {
    final Parameter<?> param = new Parameter<>(key, value, valueType);
    this.parameterList.add(param);
    return this;
  }


  /**
   * Generates an event
   *
   * @return {@link Event}
   */
  public Event getEvent() {
    if (this.timeStamp == 0) {
      this.timeStamp = System.currentTimeMillis();
    }
    final Event event = new Event(this.actionId, false, this.timeStamp, this.parameterList);
    return event;
  }
}
