/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.json.schema;

import com.google.common.reflect.TypeToken;

import org.apache.commons.lang3.ClassUtils;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class JavaReflectionUtils {

  /**
   * Returns all the fields of the class provided including the fields of all
   * its ancestors.
   * 
   * @param anyClass Class to get fields for.
   * @return List of fields.
   */
  public static Field[] getAllFields(final Class anyClass) {
    final Map<String, Field> stringFieldMap = new TreeMap<>();
    Class currentClass = anyClass;
    Field allField[] = anyClass.getDeclaredFields();
    for (final Field field : allField) {
      stringFieldMap.put(field.getName(), field);
    }
    while (currentClass.getSuperclass() != Object.class) {
      allField = currentClass.getSuperclass().getDeclaredFields();
      for (final Field field : allField) {
        stringFieldMap.put(field.getName(), field);
      }
      currentClass = currentClass.getSuperclass();
    }
    return stringFieldMap.values().toArray(new Field[stringFieldMap.size()]);
  }

  public static boolean isInd2ucePrimitive(Class aClass) {
    return ClassUtils.isPrimitiveOrWrapper(aClass) || aClass.isEnum() || aClass == String.class || aClass == Date.class ? true : false;
  }

  public static boolean isIterable(Class aClass) {
    return TypeToken.of(aClass).isSubtypeOf(Iterable.class);
  }

  public static boolean isMap(Class aClass) {
    return TypeToken.of(aClass).isSubtypeOf(Map.class);
  }

}
