/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.logger;

import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class SysoutLogger
implements Logger {
    private static final String STRING_FORMAT = "%s";
    private static final String REGEX = "\\{\\}";
    private String name = "StandardOutLogger";

    public SysoutLogger() {
    }

    public SysoutLogger(String name) {
        this.name = name;
    }

    public void debug(Marker marker, String msg) {
        this.log(LoggerFactory.LogLevel.DEBUG, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg + "\n" + this.stackTraceToString(t));
    }

    public void debug(String msg) {
        this.log(LoggerFactory.LogLevel.DEBUG, msg);
    }

    public void debug(String format, Object arg) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void debug(String msg, Throwable t) {
        this.debug(msg + "\n" + this.stackTraceToString(t));
    }

    public void error(Marker marker, String msg) {
        this.log(LoggerFactory.LogLevel.ERROR, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg + "\n" + this.stackTraceToString(t));
    }

    public void error(String msg) {
        this.log(LoggerFactory.LogLevel.ERROR, msg);
    }

    public void error(String format, Object arg) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void error(String format, Object ... arguments) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void error(String msg, Throwable t) {
        this.error(msg + "\n" + this.stackTraceToString(t));
    }

    public String getName() {
        return this.name;
    }

    public void info(Marker marker, String msg) {
        this.log(LoggerFactory.LogLevel.INFO, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg + "\n" + this.stackTraceToString(t));
    }

    public void info(String msg) {
        this.log(LoggerFactory.LogLevel.INFO, msg);
    }

    public void info(String format, Object arg) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void info(String format, Object ... arguments) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void info(String msg, Throwable t) {
        this.info(msg + "\n" + this.stackTraceToString(t));
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void log(LoggerFactory.LogLevel level, String msg) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.YYYY HH:mm:ss");
        Date date = new Date();
        System.out.println("[" + dateFormat.format(date) + "][" + this.name + "][" + String.format("%5s", new Object[]{level}) + "] " + msg);
    }

    private String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public void trace(Marker marker, String msg) {
        this.log(LoggerFactory.LogLevel.TRACE, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg + "\n" + this.stackTraceToString(t));
    }

    public void trace(String msg) {
        this.log(LoggerFactory.LogLevel.TRACE, msg);
    }

    public void trace(String format, Object arg) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void trace(String format, Object ... arguments) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void trace(String msg, Throwable t) {
        this.trace(msg + "\n" + this.stackTraceToString(t));
    }

    public void warn(Marker marker, String msg) {
        this.log(LoggerFactory.LogLevel.WARN, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg + "\n" + this.stackTraceToString(t));
    }

    public void warn(String msg) {
        this.log(LoggerFactory.LogLevel.WARN, msg);
    }

    public void warn(String format, Object arg) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        this.warn(msg + "\n" + this.stackTraceToString(t));
    }
}

