/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.logger;

import de.fraunhofer.iese.ind2uce.logger.AndroidLogger;
import de.fraunhofer.iese.ind2uce.logger.SysoutLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class LoggerFactory {
    private static LoggerFramework usedLogger = LoggerFramework.LOGBACK;
    private static LogLevel logLevel = LogLevel.DEBUG;
    private static AndroidLogger androidLogger;

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        Class<?> loggerFactoryClass;
        try {
            loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Method method = loggerFactoryClass.getMethod("getLogger", String.class);
            Object o = method.invoke(null, name);
            usedLogger = LoggerFramework.LOGBACK;
            if (!(o instanceof NOPLogger)) {
                return (Logger)o;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        try {
            loggerFactoryClass = Class.forName("android.util.Log");
            usedLogger = LoggerFramework.ANDROID;
            androidLogger = new AndroidLogger(name, logLevel);
            return androidLogger;
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            usedLogger = LoggerFramework.STDOUT;
            return new SysoutLogger(name);
        }
    }

    public static boolean setRootLevel(LogLevel newLevel) {
        logLevel = newLevel;
        if (usedLogger == LoggerFramework.ANDROID) {
            androidLogger.setLogLevel(newLevel);
            return true;
        }
        if (usedLogger == LoggerFramework.LOGBACK) {
            try {
                Class<?> rootLogger = Class.forName("ch.qos.logback.classic.Logger");
                Class<?> slf4jLoggerFactory = Class.forName("org.slf4j.LoggerFactory");
                Method method = slf4jLoggerFactory.getMethod("getLogger", String.class);
                Object o = method.invoke(null, "ROOT");
                Class<?> levelClass = Class.forName("ch.qos.logback.classic.Level");
                Method m2 = rootLogger.getMethod("setLevel", levelClass);
                Method m3 = levelClass.getMethod("toLevel", Integer.TYPE);
                switch (newLevel) {
                    case OFF: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, Integer.MAX_VALUE));
                        break;
                    }
                    case ERROR: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, 40000));
                        break;
                    }
                    case WARN: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, 30000));
                        break;
                    }
                    case INFO: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, 20000));
                        break;
                    }
                    case DEBUG: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, 10000));
                        break;
                    }
                    case TRACE: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, 5000));
                        break;
                    }
                    default: {
                        m2.invoke(rootLogger.cast(o), m3.invoke(null, 10000));
                        break;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            System.err.println("LoggerFramework not supported");
            return false;
        }
        return true;
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }

    public static enum LoggerFramework {
        LOGBACK,
        SLF4J,
        ANDROID,
        STDOUT;

    }
}

