/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.logger;

import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class AndroidLogger
implements Logger {
    private static final String STRING_FORMAT = "%s";
    private static final String REGEX = "\\{\\}";
    private static final int TRACE_LEVEL = 5000;
    private static final int DEBUG_LEVEL = 10000;
    private static final int INFO_LEVEL = 20000;
    private static final int WARN_LEVEL = 30000;
    private static final int ERROR_LEVEL = 40000;
    private static final int OFF_LEVEL = Integer.MAX_VALUE;
    private String name = "AndroidLogger";
    private Class<?> androidLoggerClass;
    private Method trace;
    private Method debug;
    private Method info;
    private Method warn;
    private Method error;
    private LoggerFactory.LogLevel logLevel;

    public AndroidLogger(String name, LoggerFactory.LogLevel logLevel) {
        this.name = name;
        this.logLevel = logLevel;
        try {
            this.androidLoggerClass = Class.forName("android.util.Log");
            this.trace = this.androidLoggerClass.getMethod("v", String.class, String.class);
            this.debug = this.androidLoggerClass.getMethod("d", String.class, String.class);
            this.info = this.androidLoggerClass.getMethod("i", String.class, String.class);
            this.warn = this.androidLoggerClass.getMethod("w", String.class, String.class);
            this.error = this.androidLoggerClass.getMethod("e", String.class, String.class);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            System.err.println("androidLoggerClass not found!");
            e.printStackTrace();
        }
    }

    private boolean checkLogLevel(LoggerFactory.LogLevel logLevel) {
        return this.getLogLevelValue(this.logLevel) <= this.getLogLevelValue(logLevel);
    }

    public void debug(Marker marker, String msg) {
        try {
            this.debug.invoke(null, this.shortenName(this.name), msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg + "\n" + this.stackTraceToString(t));
    }

    public void debug(String msg) {
        try {
            if (this.checkLogLevel(LoggerFactory.LogLevel.DEBUG)) {
                this.debug.invoke(null, this.shortenName(this.name), msg);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void debug(String format, Object arg) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void debug(String msg, Throwable t) {
        this.debug(msg + "\n" + this.stackTraceToString(t));
    }

    public void error(Marker marker, String msg) {
        try {
            this.error.invoke(null, this.shortenName(this.name), msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg + "\n" + this.stackTraceToString(t));
    }

    public void error(String msg) {
        try {
            if (this.checkLogLevel(LoggerFactory.LogLevel.ERROR)) {
                this.error.invoke(null, this.shortenName(this.name), msg);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void error(String format, Object arg) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void error(String format, Object ... arguments) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void error(String msg, Throwable t) {
        this.error(msg + "\n" + this.stackTraceToString(t));
    }

    public LoggerFactory.LogLevel getLogLevel() {
        return this.logLevel;
    }

    private int getLogLevelValue(LoggerFactory.LogLevel logLevel) {
        switch (logLevel) {
            case OFF: {
                return Integer.MAX_VALUE;
            }
            case TRACE: {
                return 5000;
            }
            case DEBUG: {
                return 10000;
            }
            case INFO: {
                return 20000;
            }
            case WARN: {
                return 30000;
            }
            case ERROR: {
                return 40000;
            }
        }
        return 10000;
    }

    public String getName() {
        return this.name;
    }

    public void info(Marker marker, String msg) {
        try {
            this.info.invoke(null, this.shortenName(this.name), msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg + "\n" + this.stackTraceToString(t));
    }

    public void info(String msg) {
        try {
            if (this.checkLogLevel(LoggerFactory.LogLevel.INFO)) {
                this.info.invoke(null, this.shortenName(this.name), msg);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void info(String format, Object arg) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void info(String format, Object ... arguments) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void info(String msg, Throwable t) {
        this.info(msg + "\n" + this.stackTraceToString(t));
    }

    public boolean isDebugEnabled() {
        return this.checkLogLevel(LoggerFactory.LogLevel.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.checkLogLevel(LoggerFactory.LogLevel.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.checkLogLevel(LoggerFactory.LogLevel.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.checkLogLevel(LoggerFactory.LogLevel.ERROR);
    }

    public boolean isInfoEnabled() {
        return this.checkLogLevel(LoggerFactory.LogLevel.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.checkLogLevel(LoggerFactory.LogLevel.INFO);
    }

    public boolean isTraceEnabled() {
        return this.checkLogLevel(LoggerFactory.LogLevel.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.checkLogLevel(LoggerFactory.LogLevel.TRACE);
    }

    public boolean isWarnEnabled() {
        return this.checkLogLevel(LoggerFactory.LogLevel.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.checkLogLevel(LoggerFactory.LogLevel.WARN);
    }

    public void setLogLevel(LoggerFactory.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    private String shortenName(String name) {
        if (name.length() > 30) {
            return "..." + name.substring(name.length() - 30, name.length());
        }
        return name;
    }

    private String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public void trace(Marker marker, String msg) {
        try {
            this.trace.invoke(null, this.shortenName(this.name), msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg + "\n" + this.stackTraceToString(t));
    }

    public void trace(String msg) {
        try {
            if (this.checkLogLevel(LoggerFactory.LogLevel.TRACE)) {
                this.trace.invoke(null, this.shortenName(this.name), msg);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void trace(String format, Object arg) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void trace(String format, Object ... arguments) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void trace(String msg, Throwable t) {
        this.trace(msg + "\n" + this.stackTraceToString(t));
    }

    public void warn(Marker marker, String msg) {
        try {
            this.warn.invoke(null, this.shortenName(this.name), msg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg + "\n" + this.stackTraceToString(t));
    }

    public void warn(String msg) {
        try {
            if (this.checkLogLevel(LoggerFactory.LogLevel.WARN)) {
                this.warn.invoke(null, this.shortenName(this.name), msg);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void warn(String format, Object arg) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        this.warn(msg + "\n" + this.stackTraceToString(t));
    }
}

