/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.connectors;

import de.fraunhofer.iese.ind2uce.api.component.Component;
import de.fraunhofer.iese.ind2uce.api.component.ComponentBase;
import de.fraunhofer.iese.ind2uce.api.component.ComponentType;
import de.fraunhofer.iese.ind2uce.api.component.PepComponent;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IComponent;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyDecisionPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyExecutionPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyInformationPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyManagementPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyRetrievalPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IRootPolicyManagementPoint;
import de.fraunhofer.iese.ind2uce.connectors.Authentication;
import de.fraunhofer.iese.ind2uce.connectors.Connector;
import de.fraunhofer.iese.ind2uce.connectors.OAuthCredentials;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;

public final class ConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorFactory.class);
    private static final List<String> connectorPriorities = Arrays.asList("binder", "amqp", "http", "https", "tcp", "rmi");
    private static Set<Class<?>> connectorClasses;

    private ConnectorFactory() {
    }

    private static boolean contains(String[] array, String query) {
        for (String element : array) {
            if (!element.equals(query)) continue;
            return true;
        }
        return false;
    }

    public static IComponent getComponent(ComponentBase base, String preferredConnectorType) {
        return ConnectorFactory.getComponent(base, preferredConnectorType, null);
    }

    public static IComponent getComponent(ComponentBase base, String preferredConnectorType, Map<String, Authentication> protocolToAuthentication) {
        IComponent component;
        LOG.trace("Entering getConnector(base={}, preferredConnectorType={})", (Object)base, (Object)preferredConnectorType);
        if (null == base) {
            return null;
        }
        switch (base.getType()) {
            case PDP: {
                component = ConnectorFactory.getPdp((Component)base, preferredConnectorType, protocolToAuthentication);
                break;
            }
            case PEP: {
                component = ConnectorFactory.getPep((PepComponent)base, preferredConnectorType);
                break;
            }
            case PMP: {
                component = ConnectorFactory.getPmpClient((Component)base, preferredConnectorType);
                break;
            }
            case PMP_SERVER: {
                component = ConnectorFactory.getPmpServer((Component)base, preferredConnectorType);
                break;
            }
            case PXP: {
                component = ConnectorFactory.getPxp((Component)base, preferredConnectorType);
                break;
            }
            case PIP: {
                component = ConnectorFactory.getPip((Component)base, preferredConnectorType);
                break;
            }
            case PRP: {
                component = ConnectorFactory.getPrp((Component)base, preferredConnectorType);
                break;
            }
            default: {
                LOG.warn("Unknown Component type {}", (Object)base.getType());
                component = null;
            }
        }
        LOG.trace("Returning from getConnector(component={})", (Object)component);
        return component;
    }

    private static <T extends IComponent> T getConnector(ComponentBase component, ComponentType type, String preferredConnectorType, Map<String, Authentication> protocolToAuthentication) {
        LOG.info("Entering getConnector(component={}, type={})", (Object)component, (Object)type);
        if (component.getUrls() == null || component.getUrls().isEmpty()) {
            return null;
        }
        if (component.getUrls().size() == 1) {
            return ConnectorFactory.getConnector(component.getUrls().get(0), type, null);
        }
        URI connectorURI = null;
        if (preferredConnectorType != null) {
            for (URI uri : component.getUrls()) {
                if (!uri.getScheme().equalsIgnoreCase(preferredConnectorType)) continue;
                connectorURI = uri;
                break;
            }
        }
        if (connectorURI == null) {
            Collections.sort(component.getUrls(), new Comparator<URI>(){

                @Override
                public int compare(URI o1, URI o2) {
                    Integer prio1 = this.getPriority(o1.getScheme());
                    Integer prio2 = this.getPriority(o2.getScheme());
                    return -prio1.compareTo(prio2);
                }

                private int getPriority(String protocol) {
                    return connectorPriorities.indexOf(protocol);
                }
            });
            connectorURI = component.getUrls().get(0);
        }
        Authentication authenticationForConnector = null;
        if (protocolToAuthentication != null && protocolToAuthentication.containsKey(connectorURI.getScheme())) {
            authenticationForConnector = protocolToAuthentication.get(connectorURI.getScheme());
        }
        T componentConnector = ConnectorFactory.getConnector(connectorURI, type, authenticationForConnector);
        LOG.trace("Leaving getConnector(): {}", componentConnector);
        return componentConnector;
    }

    private static <T extends IComponent> T getConnector(@Nonnull URI url, @Nonnull ComponentType type, @Nullable Authentication authentication) {
        LOG.trace("Entering getConnector(url={}, type={})", (Object)url, (Object)type);
        ConnectorFactory.loadClasses();
        String protocol = url.getScheme();
        String version = null;
        try {
            Pattern p = Pattern.compile("(?<=version=).*?(?=&|$)");
            Matcher m = p.matcher(url.toASCIIString());
            while (m.find()) {
                version = m.group();
            }
        }
        catch (PatternSyntaxException ex) {
            LOG.warn("Could read version from scheme. Ignoring.", (Throwable)ex);
        }
        for (Class<?> connector : connectorClasses) {
            Connector annotation = connector.getAnnotation(Connector.class);
            boolean annotationOk = annotation.type() == type;
            boolean protocolOk = ConnectorFactory.contains(annotation.protocol(), protocol);
            if (!annotationOk || !protocolOk) continue;
            try {
                Constructor<?> constructor = ConnectorFactory.getConstructor(connector, authentication);
                T result = ConnectorFactory.createInstance(url, authentication, constructor);
                LOG.trace("Leaving getConnector(): {}", result);
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.warn("Could not instantiate connector", (Throwable)e);
            }
        }
        LOG.info("Cannot find connector for (url={}, type={})", (Object)url, (Object)type);
        return null;
    }

    private static <T extends IComponent> T createInstance(URI url, Authentication credentials, Constructor<?> constructor) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return (T)((IComponent)(credentials != null ? constructor.newInstance(url, credentials) : constructor.newInstance(url)));
    }

    private static Constructor<?> getConstructor(Class<?> connector, Authentication credentials) throws NoSuchMethodException {
        return credentials != null ? connector.getConstructor(URI.class, Authentication.class) : connector.getConstructor(URI.class);
    }

    public static IPolicyDecisionPoint getPdp(Component component, String preferredConnectorType, Map<String, Authentication> protocolToAuthentication) {
        return (IPolicyDecisionPoint)ConnectorFactory.getConnector(component, ComponentType.PDP, preferredConnectorType, protocolToAuthentication);
    }

    public static IPolicyDecisionPoint getPdp(URI url) {
        return (IPolicyDecisionPoint)ConnectorFactory.getConnector(url, ComponentType.PDP, null);
    }

    public static IPolicyDecisionPoint getPdp(URI url, Authentication credentials) {
        return (IPolicyDecisionPoint)ConnectorFactory.getConnector(url, ComponentType.PDP, credentials);
    }

    public static IPolicyEnforcementPoint getPep(PepComponent component, String preferredConnectorType) {
        return (IPolicyEnforcementPoint)ConnectorFactory.getConnector(component, ComponentType.PEP, preferredConnectorType, null);
    }

    public static IPolicyEnforcementPoint getPep(URI url) {
        return (IPolicyEnforcementPoint)ConnectorFactory.getConnector(url, ComponentType.PEP, null);
    }

    public static IPolicyInformationPoint getPip(Component component, String preferredConnectorType) {
        return (IPolicyInformationPoint)ConnectorFactory.getConnector(component, ComponentType.PIP, preferredConnectorType, null);
    }

    public static IPolicyInformationPoint getPip(URI url) {
        return (IPolicyInformationPoint)ConnectorFactory.getConnector(url, ComponentType.PIP, null);
    }

    public static IPolicyManagementPoint getPmpClient(Component component, String preferredConnectorType) {
        return (IPolicyManagementPoint)ConnectorFactory.getConnector(component, ComponentType.PMP, preferredConnectorType, null);
    }

    public static IPolicyManagementPoint getPmpClient(URI url, OAuthCredentials oAuthCredentials) {
        return (IPolicyManagementPoint)ConnectorFactory.getConnector(url, ComponentType.PMP, oAuthCredentials);
    }

    public static IPolicyManagementPoint getPmpClient(URI url) {
        return (IPolicyManagementPoint)ConnectorFactory.getConnector(url, ComponentType.PMP, null);
    }

    public static IRootPolicyManagementPoint getPmpServer(Component component, String preferredConnectorType) {
        return (IRootPolicyManagementPoint)ConnectorFactory.getConnector(component, ComponentType.PMP_SERVER, preferredConnectorType, null);
    }

    public static IRootPolicyManagementPoint getPmpServer(URI url) {
        return (IRootPolicyManagementPoint)ConnectorFactory.getConnector(url, ComponentType.PMP_SERVER, null);
    }

    public static IPolicyRetrievalPoint getPrp(Component component, String preferredConnectorType) {
        return (IPolicyRetrievalPoint)ConnectorFactory.getConnector(component, ComponentType.PRP, preferredConnectorType, null);
    }

    public static IPolicyRetrievalPoint getPrp(URI url) {
        return (IPolicyRetrievalPoint)ConnectorFactory.getConnector(url, ComponentType.PRP, null);
    }

    public static IPolicyExecutionPoint getPxp(Component component, String preferredConnectorType) {
        return (IPolicyExecutionPoint)ConnectorFactory.getConnector(component, ComponentType.PXP, preferredConnectorType, null);
    }

    public static IPolicyExecutionPoint getPxp(URI url) {
        return (IPolicyExecutionPoint)ConnectorFactory.getConnector(url, ComponentType.PXP, null);
    }

    protected static void loadClasses() {
        if (connectorClasses == null) {
            Reflections reflections = new Reflections("de", new Scanner[0]);
            connectorClasses = reflections.getTypesAnnotatedWith(Connector.class);
        }
    }
}

