/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.parameter;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ParameterList
extends ArrayList<Parameter<?>> {
    private static final long serialVersionUID = 7913615319509313890L;

    public ParameterList() {
    }

    public ParameterList(Collection<? extends Parameter<?>> params) {
        if (params != null) {
            this.addAll(params);
        }
    }

    public ParameterList(Parameter<?> ... params) {
        if (params != null) {
            this.addAll(Arrays.asList(params));
        }
    }

    @Override
    public boolean add(Parameter<?> e) {
        if (e != null) {
            for (Parameter param : this) {
                if (!e.getName().equals(param.getName())) continue;
                return false;
            }
            return super.add(e);
        }
        return false;
    }

    public <T> void addParameter(String name, T value) {
        this.add(new Parameter<T>(name, value));
    }

    public <T> void addParameter(String name, T value, Type valueType) {
        this.add(new Parameter<T>(name, value, valueType));
    }

    public Parameter<?> getParameterForName(String name) {
        if (name != null) {
            for (Parameter param : this) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
        }
        return null;
    }

    public <T> T getParameterValue(String name, Class<T> clazz) throws ClassCastException {
        Parameter<?> param = this.getParameterForName(name);
        if (param == null) {
            return null;
        }
        Object value = param.getValue();
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new ClassCastException("Parameter of type " + value.getClass().getCanonicalName() + " cannot be cast to " + clazz);
    }

    public Object getParameterValueForName(String name) {
        Parameter<?> prameter = this.getParameterForName(name);
        if (prameter != null) {
            return prameter.getValue();
        }
        return null;
    }

    public void removeParameter(String name) {
        this.remove(this.getParameterForName(name));
    }

    public void setParameters(ParameterList params) {
        if (params != null) {
            this.clear();
            this.addAll(params);
        }
    }

    public Parameter<?>[] toArray() {
        return this.toArray(new Parameter[this.size()]);
    }
}

