/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.parameter;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.DataObject;
import java.lang.reflect.Type;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Parameter<T>
extends Ind2uceEntity {
    private static final long serialVersionUID = 6426150182821452997L;
    private String name;
    private DataObject<T> value;

    public Parameter(String name, T value) {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value required");
        }
        this.name = name;
        this.value = new DataObject<T>(value);
    }

    public Parameter(String name, T value, Class<T> clazz) {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value required");
        }
        this.name = name;
        this.value = new DataObject<T>(value, clazz);
    }

    public Parameter(String name, T value, Type valueType) {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value required");
        }
        this.name = name;
        this.value = new DataObject<T>(value, valueType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.value.getType();
    }

    public String getTypeName() {
        return this.value.getTypeName();
    }

    public T getValue() {
        return this.value.getValue();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.name);
        if (this.value != null) {
            builder.append(this.value.getValue());
            builder.append(this.value.getType());
        }
        return builder.toHashCode();
    }

    public void setDataObjectJavaType(Type type) {
        this.value.setJavaType(type);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(T value) {
        this.value = new DataObject<T>(value);
    }

    @Override
    public String toString() {
        return "  " + this.name + ": " + this.value;
    }
}

