/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.parameter;

import de.fraunhofer.iese.ind2uce.api.policy.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ModifierList
extends ArrayList<Modifier> {
    private static final long serialVersionUID = 7913615319509313890L;

    public ModifierList() {
    }

    public ModifierList(Collection<? extends Modifier> params) {
        if (params != null) {
            this.addAll(params);
        }
    }

    public ModifierList(Modifier ... params) {
        if (params != null) {
            this.addAll(Arrays.asList(params));
        }
    }

    @Override
    public boolean add(Modifier e) {
        if (this.contains(e)) {
            return false;
        }
        return super.add(e);
    }

    public <T> void addParameter(String name) {
        this.add(new Modifier(name, null));
    }

    public Modifier getParameterForName(String name) {
        if (name != null) {
            for (Modifier param : this) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
        }
        return null;
    }

    public void removeParameter(String name) {
        this.remove(this.getParameterForName(name));
    }

    public void setParameters(ModifierList params) {
        if (params != null) {
            this.clear();
        }
        this.addAll(params);
    }

    public Modifier[] toArray() {
        return this.toArray(new Modifier[this.size()]);
    }
}

