/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.parameter;

public enum DataType {
    STRING(String.class, 0),
    BOOL(Boolean.class, 8),
    INT(Integer.class, 6),
    LONG(Long.class, 7),
    FLOAT(Float.class, 10),
    DOUBLE(Double.class, 11),
    DATAUSAGE(String.class, 1),
    XPATH(String.class, 2),
    REGEX(String.class, 3),
    CONTEXT(String.class, 4),
    BINARY(byte[].class, 5),
    STRING_ARRAY(String[].class, 9);

    private Class<?> clazz;
    private int typeId;

    private DataType(Class<?> clazz, int typeId) {
        this.clazz = clazz;
        this.typeId = typeId;
    }

    public static DataType getByClass(Class<?> clazz) {
        for (DataType type : DataType.values()) {
            if (type.getDataTypeClass() != clazz) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported Type");
    }

    public static DataType getById(int id) {
        for (DataType type : DataType.values()) {
            if (type.getDataTypeId() != id) continue;
            return type;
        }
        return null;
    }

    public Class<?> getDataTypeClass() {
        return this.clazz;
    }

    public int getDataTypeId() {
        return this.typeId;
    }

    public boolean matches(Class<?> clazz, int id) {
        for (DataType type : DataType.values()) {
            if (type.getDataTypeId() != id) continue;
            return clazz == type.getDataTypeClass();
        }
        return false;
    }
}

