/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.parameter;

import com.google.gson.internal.Primitives;
import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.lang.reflect.Type;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;

public class DataObject<T>
extends Ind2uceEntity {
    private static final long serialVersionUID = 6426150182821452997L;
    private static final Logger log = LoggerFactory.getLogger("DataObject<T>");
    boolean isComplex = false;
    private T value;
    private String type;
    private transient Type javaType;

    public DataObject() {
    }

    public DataObject(Class<T> type) {
        this.type = type.getCanonicalName();
    }

    public DataObject(T value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        if (this.value != null) {
            this.type = value.getClass().getCanonicalName();
        }
    }

    public DataObject(T value, Class<T> clazz) {
        this(value);
        if (value.getClass() != clazz && !super.primitiveTypesMatches(value, clazz)) {
            throw new IllegalArgumentException("Incompatible data types: " + value.getClass() + ", " + clazz);
        }
        this.type = clazz.getCanonicalName();
    }

    public DataObject(T value, Type type) {
        this(value);
        this.javaType = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataObject)) {
            return false;
        }
        DataObject other = (DataObject)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.getValue()));
    }

    public void setJavaType(Type javaType) {
        this.javaType = javaType;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.type);
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found for " + this.type, (Throwable)e);
            return null;
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        if (this.value != null) {
            this.type = value.getClass().getCanonicalName();
        }
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.type);
        builder.append(this.value);
        return builder.toHashCode();
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public void setComplex(boolean b) {
        this.isComplex = b;
    }

    private boolean primitiveTypesMatches(T value, Class<T> clazz) {
        return Primitives.isWrapperType(value.getClass()) && Primitives.unwrap(value.getClass()) == clazz || Primitives.isWrapperType(clazz) && Primitives.unwrap(clazz) == value.getClass();
    }

    @Override
    public String toString() {
        return this.value == null ? null : this.value.toString();
    }
}

