/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.identifier;

import de.fraunhofer.iese.ind2uce.api.policy.PolicyType;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.PolicyId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public class PolicyIdUtil {
    private static final Pattern URN_POLICY_PATTERN = Pattern.compile("^urn:policy(:([A-Za-z0-9()+,\\-.=@;$_!*']+)){2}$", 2);

    public static PolicyId createPolicyId(String urn) {
        PolicyId policyId = new PolicyId();
        PolicyIdUtil.setAttributesByUrn(urn, policyId);
        return policyId;
    }

    private static void setAttributes(String urn, PolicyId policyId) {
        String[] result = urn.split(":");
        if (result.length > 2) {
            policyId.setScope(result[2]);
        }
        if (result.length > 3) {
            Iterator<String> iter = Arrays.asList(Arrays.copyOfRange(result, 3, result.length)).iterator();
            StringBuilder s = new StringBuilder();
            while (iter.hasNext()) {
                s.append(iter.next());
                if (!iter.hasNext()) continue;
                s.append(":");
            }
            policyId.setIdentifier(s.toString());
        }
    }

    public static void setAttributesByUrn(String urn, PolicyId instance) {
        if (!URN_POLICY_PATTERN.matcher(urn).matches()) {
            throw new IllegalArgumentException("URN " + urn + " does not match the pattern " + URN_POLICY_PATTERN);
        }
        PolicyIdUtil.setILPAttributesByUrn(urn, instance);
    }

    private static PolicyId setILPAttributesByUrn(String urn, PolicyId policyId) {
        PolicyIdUtil.setAttributes(urn, policyId);
        policyId.setPolicyType(PolicyType.ILP);
        return policyId;
    }
}

