/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;
import de.fraunhofer.iese.ind2uce.api.policy.PolicyType;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.PolicyIdUtil;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
public class PolicyId
extends Ind2uceEntity {
    private static final long serialVersionUID = 4279735491466729161L;
    @Enumerated(value=EnumType.STRING)
    @Column(name="policy_type", length=8)
    private PolicyType policyType = null;
    @Column(name="scope", length=70)
    private String scope;
    @Column(name="identifier", length=70)
    private String identifier;

    public PolicyId() {
    }

    public PolicyId(String urn) {
        PolicyIdUtil.setAttributesByUrn(urn, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyId)) {
            return false;
        }
        PolicyId policyId = (PolicyId)o;
        if (this.policyType != policyId.policyType) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(policyId.scope) : policyId.scope != null) {
            return false;
        }
        return this.identifier != null ? this.identifier.equals(policyId.identifier) : policyId.identifier == null;
    }

    public EnforcementScopeId getEsType() {
        if (this.policyType == PolicyType.ILP) {
            return new EnforcementScopeId("urn:es:" + this.scope);
        }
        return null;
    }

    public String getId() {
        return this.toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public PolicyType getPolicyType() {
        return this.policyType;
    }

    public String getScope() {
        return this.scope;
    }

    public PolicyType getType() {
        return this.policyType;
    }

    public int hashCode() {
        int result = this.policyType != null ? this.policyType.hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        return result;
    }

    public void setId(String uri) {
        PolicyIdUtil.setAttributesByUrn(uri, this);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPolicyType(PolicyType policyType) {
        this.policyType = policyType;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        if (this.policyType == null || this.identifier == null || this.scope == null) {
            return "PolicyId not initialized.";
        }
        StringBuilder s = new StringBuilder();
        s.append("urn:");
        if (this.getType() == PolicyType.ILP) {
            s.append("policy");
        } else {
            s.append(this.getType().toString().toLowerCase());
        }
        s.append(":");
        s.append(this.getScope());
        s.append(":");
        s.append(this.getIdentifier());
        return s.toString();
    }
}

