/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.identifier;

import java.util.regex.Pattern;

public class DecisionId {
    private static final long serialVersionUID = -757909380475601881L;
    public static final Pattern URN_DECISION_PATTERN = Pattern.compile("^urn:decision(:[a-z0-9()+,\\-.=@;$_!*']+)$", 2);
    private final String identifier;

    public DecisionId(String id) {
        this.validate(id);
        this.identifier = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecisionId)) {
            return false;
        }
        DecisionId that = (DecisionId)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public String getId() {
        return this.toString();
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return this.identifier;
    }

    protected void validate(String uri) {
        URN_DECISION_PATTERN.matcher(uri).matches();
    }
}

