/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class ActionId
extends Ind2uceEntity {
    private static final long serialVersionUID = 4279735491466729161L;
    public static final Pattern URN_ACTION_PATTERN = Pattern.compile("^urn:action(:[A-Za-z0-9()+,\\-.=@;$_!*']+){2}$", 2);
    @Column(name="action_scope")
    private String scope;
    @Column(name="action")
    private String action;

    ActionId() {
    }

    public ActionId(String urn) {
        this.validate(urn);
        String[] s = urn.split(":");
        assert (s.length > 3);
        assert (s[0].equalsIgnoreCase("urn"));
        assert (s[1].equalsIgnoreCase("action"));
        this.scope = s[2];
        this.action = s[3];
    }

    public ActionId(String scope, String actionId) {
        this.scope = scope;
        this.action = actionId;
        this.validate(this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionId)) {
            return false;
        }
        ActionId actionId = (ActionId)o;
        if (this.scope != null ? !this.scope.equals(actionId.scope) : actionId.scope != null) {
            return false;
        }
        return this.action != null ? this.action.equals(actionId.action) : actionId.action == null;
    }

    public String getAction() {
        return this.action;
    }

    public String getId() {
        return this.toString();
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int result = this.scope != null ? this.scope.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("urn:action:");
        s.append(this.scope);
        s.append(":");
        s.append(this.action);
        return s.toString();
    }

    protected void validate(String uri) {
        URN_ACTION_PATTERN.matcher(uri).matches();
    }
}

