/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.policy.ITimerValidator;
import de.fraunhofer.iese.ind2uce.api.policy.InvalidTimerException;
import de.fraunhofer.iese.ind2uce.api.policy.Timer;
import de.fraunhofer.iese.ind2uce.api.policy.TimerValidator46;

public class TimerValidator
implements ITimerValidator {
    private static final ITimerValidator TIMER_VALIDATOR_46 = new TimerValidator46();

    @Override
    public boolean validateXMLSchema(String timer) throws InvalidTimerException {
        if (timer == null) {
            throw new InvalidTimerException("Timer must not be null");
        }
        if (timer.contains("http://www.iese.fraunhofer.de/ind2uce/3.2.46/ind2uceLanguageTimer")) {
            return TIMER_VALIDATOR_46.validateXMLSchema(timer);
        }
        throw new InvalidTimerException("Unsupported timer version");
    }

    @Override
    public boolean checkTimerSolution(Timer timer) throws InvalidTimerException {
        if (timer == null) {
            throw new InvalidTimerException("Timer must not be null");
        }
        if (timer.getXml().contains("http://www.iese.fraunhofer.de/ind2uce/3.2.46/ind2uceLanguageTimer")) {
            return TIMER_VALIDATOR_46.checkTimerSolution(timer);
        }
        throw new InvalidTimerException("Unsupported timer version");
    }
}

