/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.api.policy.InvalidTimerException;
import de.fraunhofer.iese.ind2uce.api.policy.TimerValidator;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Transient;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.dom.DeferredElementImpl;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Entity
public class Timer {
    private static final Logger LOG = LoggerFactory.getLogger(Timer.class);
    private static final String VALUE = "value";
    public static final Pattern URN_TIMER_PATTERN = Pattern.compile("^urn:timer(:[A-Za-z0-9()+,\\-.=@;$_!*']+){2}$", 2);
    @Column(name="identifier", length=70)
    private String identifier;
    @Column(length=64, nullable=false)
    private String cronValue;
    @Column(nullable=false)
    private boolean deployed;
    @Column(length=512)
    private String description;
    @Lob
    private String xml;
    @Column(length=255)
    private String scope;
    @Id
    @Column(length=255)
    private String id;
    @Transient
    private List<Event> events;
    @Transient
    private boolean xmlValid = false;
    @Transient
    private boolean scopeValid = false;
    @Transient
    private InvalidTimerException invalidTimerException;

    public boolean isXmlValid() {
        return this.xmlValid;
    }

    public InvalidTimerException getInvalidTimerException() {
        return this.invalidTimerException;
    }

    public void setXmlValid(boolean xmlValid) {
        this.xmlValid = xmlValid;
    }

    public void setScopeValid(boolean isScopeValid) {
        this.scopeValid = isScopeValid;
    }

    public void setInvalidTimerException(InvalidTimerException invalidTimerException) {
        this.invalidTimerException = invalidTimerException;
    }

    public boolean isScopeValid() {
        return this.scopeValid;
    }

    public Timer(String xml) throws InvalidTimerException {
        this.xml = xml;
        this.validateXML();
        this.parse();
        this.validateScope();
    }

    public void buildFromURN(String urn) {
        this.validate(urn);
        String[] s = urn.split(":");
        assert (s.length > 3);
        assert (s[0].equalsIgnoreCase("urn"));
        assert (s[1].equalsIgnoreCase("timer"));
        this.scope = s[2];
        this.identifier = s[3];
        this.id = urn;
    }

    protected void validate(String uri) {
        if (!URN_TIMER_PATTERN.matcher(uri).matches()) {
            throw new IllegalArgumentException("TimerId " + uri + " do not match URN: " + URN_TIMER_PATTERN);
        }
    }

    private void parse() throws InvalidTimerException {
        try {
            DocumentBuilderFactory documentumentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentumentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentumentBuilder = documentumentBuilderFactory.newDocumentBuilder();
            Document document = documentumentBuilder.parse(new InputSource(new StringReader(this.xml)));
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            this.buildFromURN((String)xpath.compile("//timer/@id").evaluate(document, XPathConstants.STRING));
            this.setCronValue((String)xpath.compile("//timer/@cron").evaluate(document, XPathConstants.STRING));
            this.setDescription((String)xpath.compile("//timer/@description").evaluate(document, XPathConstants.STRING));
            XPathExpression expr = xpath.compile("//timer/event");
            NodeList names = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
            this.events = new ArrayList<Event>();
            for (int i = 0; i < names.getLength(); ++i) {
                this.events.add(this.parseEvent(names.item(i)));
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new InvalidTimerException("The Timer was not valid");
        }
    }

    private Event parseEvent(Node item) {
        String action = item.getAttributes().getNamedItem("action").getNodeValue();
        ParameterList params = new ParameterList();
        for (Parameter p : this.getParametersByTagName(item, "string")) {
            params.add(p);
        }
        for (Parameter p : this.getParametersByTagName(item, "boolean")) {
            params.add(p);
        }
        for (Parameter p : this.getParametersByTagName(item, "number")) {
            params.add(p);
        }
        for (Parameter p : this.getParametersByTagName(item, "object")) {
            params.add(p);
        }
        for (Parameter p : this.getParametersByTagName(item, "list")) {
            params.add(p);
        }
        return new Event(new ActionId(action), true, System.currentTimeMillis(), params);
    }

    private Collection<Parameter> getParametersByTagName(Node item, String string) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        NodeList elementsByTagName = ((DeferredElementImpl)item).getElementsByTagName(string);
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node node = elementsByTagName.item(i);
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            Object value = null;
            switch (string) {
                case "string": {
                    value = node.getAttributes().getNamedItem(VALUE).getNodeValue();
                    break;
                }
                case "number": {
                    value = Double.valueOf(node.getAttributes().getNamedItem(VALUE).getNodeValue());
                    break;
                }
                case "boolean": {
                    value = Boolean.valueOf(node.getAttributes().getNamedItem(VALUE).getNodeValue());
                    break;
                }
                default: {
                    LOG.info("No match found for string [ method: getParametersByTagName | class TimerService]");
                }
            }
            if (null == value) continue;
            params.add(new Parameter<Object>(name, value));
        }
        return params;
    }

    public Timer() {
    }

    public String getCronValue() {
        return this.cronValue;
    }

    public void setCronValue(String cronValue) {
        this.cronValue = cronValue;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public List<Event> getEvents() throws InvalidTimerException {
        if (this.events == null || this.events.isEmpty()) {
            this.parse();
        }
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timer timer = (Timer)o;
        return this.identifier.equals(timer.identifier);
    }

    private boolean validateScope() {
        try {
            this.scopeValid = new TimerValidator().checkTimerSolution(this);
        }
        catch (InvalidTimerException e) {
            this.scopeValid = false;
            this.invalidTimerException = e;
        }
        catch (Exception e) {
            LOG.warn("Exception in method validateScope", (Throwable)e);
        }
        return this.scopeValid;
    }

    public void extractIdAndDescription() {
        try {
            this.buildFromURN(this.readAttribute("//timer/@id"));
            this.description = this.readAttribute("//timer/@description");
        }
        catch (Exception e) {
            LOG.error("Exception in method extractIdAndDescription", (Throwable)e);
        }
    }

    private String readAttribute(String xpathString) {
        DocumentBuilderFactory documentumentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentumentBuilderFactory.setNamespaceAware(false);
        try {
            DocumentBuilder documentumentBuilder = documentumentBuilderFactory.newDocumentBuilder();
            Document document = documentumentBuilder.parse(new InputSource(new StringReader(this.xml)));
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr = xpath.compile(xpathString);
            return (String)expr.evaluate(document, XPathConstants.STRING);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new IllegalArgumentException("Timer does not have attribute", e);
        }
    }

    public boolean validateXML() {
        try {
            this.xmlValid = new TimerValidator().validateXMLSchema(this.xml);
        }
        catch (InvalidTimerException e) {
            this.xmlValid = false;
            this.invalidTimerException = e;
        }
        return this.xmlValid;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }
}

