/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;
import de.fraunhofer.iese.ind2uce.api.policy.IPolicyValidator;
import de.fraunhofer.iese.ind2uce.api.policy.InvalidPolicyException;
import de.fraunhofer.iese.ind2uce.api.policy.Policy;
import de.fraunhofer.iese.ind2uce.api.policy.SimpleNamespaceContext;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PolicyValidator25
implements IPolicyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyValidator25.class);
    private static final String SCHEMA_RESOURCE_FILEPATH = "/languageSchema/enfLanguage.xsd";
    private Schema schema;
    private Validator validator;

    public PolicyValidator25() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = PolicyValidator25.class.getResource(SCHEMA_RESOURCE_FILEPATH);
            this.schema = schemaFactory.newSchema(url);
            this.validator = this.schema.newValidator();
            this.validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    LOG.error("Validation error: " + exception.getMessage());
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    LOG.error("Validation fatal error: " + exception.getMessage());
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    LOG.error("Validation warning: " + exception.getMessage());
                    throw exception;
                }
            });
            LOG.info("Successfully loaded schema");
        }
        catch (SAXException e) {
            LOG.error("Unable to create schema", (Throwable)e);
        }
    }

    @Override
    public boolean validateXMLSchema(String policyString) throws InvalidPolicyException {
        try {
            this.validator.validate(new StreamSource(new StringReader(policyString)));
        }
        catch (IOException | SAXException e) {
            LOG.info("Exception: " + e.getMessage());
            throw new InvalidPolicyException("Policy is not valid according to XML Schema", e);
        }
        return true;
    }

    @Override
    public boolean checkPolicySolution(Policy p) throws InvalidPolicyException {
        String solutionId = p.getId().getScope();
        try {
            String v;
            String actionName;
            Node n;
            int i;
            DocumentBuilderFactory documentumentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentumentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentumentBuilder = documentumentBuilderFactory.newDocumentBuilder();
            Document document = documentumentBuilder.parse(new InputSource(new StringReader(p.getPolicy())));
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            HashMap<String, String> prefMap = new HashMap<String, String>(){
                {
                    this.put("tns", "http://www.iese.fraunhofer.de/ind2uce/3.0.25/enforcementLanguage");
                    this.put("pip", "http://www.iese.fraunhofer.de/ind2uce/3.0.25/pip");
                    this.put("param", "http://www.iese.fraunhofer.de/ind2uce/3.0.25/param");
                    this.put("event", "http://www.iese.fraunhofer.de/ind2uce/3.0.25/event");
                    this.put("constant", "http://www.iese.fraunhofer.de/ind2uce/3.0.25/constant");
                    this.put("time", "http://www.iese.fraunhofer.de/ind2uce/3.0.25/time");
                }
            };
            SimpleNamespaceContext namespaces = new SimpleNamespaceContext((Map<String, String>)prefMap);
            xpath.setNamespaceContext(namespaces);
            XPathExpression expr = xpath.compile(".//tns:event");
            NodeList names = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
            ArrayList<String> errors = new ArrayList<String>();
            for (i = 0; i < names.getLength(); ++i) {
                n = names.item(i);
                actionName = n.getAttributes().getNamedItem("action").getNodeValue();
                v = actionName.split(":")[2];
                if (new EnforcementScopeId(v).getIdentifier().equals(solutionId)) continue;
                errors.add("Event " + actionName + " does not refer to an action of solution " + solutionId + ".");
            }
            expr = xpath.compile(".//pip:string|.//pip:boolean|.//pip:int|.//pip:float|.//pip:double|.//pip:object|.//pip:list");
            names = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
            for (i = 0; i < names.getLength(); ++i) {
                n = names.item(i);
                actionName = n.getAttributes().getNamedItem("method").getNodeValue();
                v = actionName.split(":")[2];
                if (new EnforcementScopeId(v).getIdentifier().equals(solutionId)) continue;
                errors.add("ExecuteAction " + actionName + " does not refer to a PXP of solution " + solutionId + ".");
            }
            expr = xpath.compile(".//tns:executeAction");
            names = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
            for (i = 0; i < names.getLength(); ++i) {
                n = names.item(i);
                String methodName = n.getAttributes().getNamedItem("name").getNodeValue();
                v = methodName.split(":")[2];
                if (new EnforcementScopeId(v).getIdentifier().equals(solutionId)) continue;
                errors.add("PIP " + methodName + " does not belong to solution " + solutionId + ".");
            }
            if (errors.size() > 0) {
                StringBuilder b = new StringBuilder();
                b.append("Policy is invalid due to the following errors:\n");
                for (String error : errors) {
                    b.append(error);
                    b.append("\n");
                }
                throw new InvalidPolicyException(b.toString());
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new InvalidPolicyException("Policy does not have attribute", e);
        }
        return true;
    }
}

