/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.policy.IPolicyValidator;
import de.fraunhofer.iese.ind2uce.api.policy.InvalidPolicyException;
import de.fraunhofer.iese.ind2uce.api.policy.Policy;
import de.fraunhofer.iese.ind2uce.api.policy.PolicyValidator25;
import de.fraunhofer.iese.ind2uce.api.policy.PolicyValidator46;

public class PolicyValidator
implements IPolicyValidator {
    private static final IPolicyValidator POLICY_VALIDATOR_25 = new PolicyValidator25();
    private static final IPolicyValidator POLICY_VALIDATOR_46 = new PolicyValidator46();

    @Override
    public boolean validateXMLSchema(String policy) throws InvalidPolicyException {
        if (policy == null) {
            throw new InvalidPolicyException("Policy must not be null");
        }
        if (policy.contains("http://www.iese.fraunhofer.de/ind2uce/3.0.25/enforcementLanguage")) {
            return POLICY_VALIDATOR_25.validateXMLSchema(policy);
        }
        if (policy.contains("")) {
            return POLICY_VALIDATOR_46.validateXMLSchema(policy);
        }
        throw new InvalidPolicyException("Unsupported policy version");
    }

    @Override
    public boolean checkPolicySolution(Policy policy) throws InvalidPolicyException {
        if (policy == null) {
            throw new InvalidPolicyException("Policy must not be null");
        }
        if (policy.getPolicy().contains("http://www.iese.fraunhofer.de/ind2uce/3.0.25/enforcementLanguage")) {
            return POLICY_VALIDATOR_25.checkPolicySolution(policy);
        }
        return POLICY_VALIDATOR_46.checkPolicySolution(policy);
    }
}

