/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.policy.InvalidPolicyException;
import de.fraunhofer.iese.ind2uce.api.policy.PolicyType;
import de.fraunhofer.iese.ind2uce.api.policy.PolicyValidator;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.PolicyId;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.Transient;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Entity
public class Policy {
    private static final Logger LOG = LoggerFactory.getLogger(Policy.class);
    @EmbeddedId
    private PolicyId id;
    @Transient
    private boolean xmlValid = false;
    @Transient
    private boolean scopeValid = false;
    @Transient
    private InvalidPolicyException invalidPolicyException;
    private boolean deployed;
    private String description;
    @ElementCollection
    @CollectionTable(name="policy_meta_data", joinColumns={@JoinColumn(referencedColumnName="policy_type", name="policy_type"), @JoinColumn(referencedColumnName="scope", name="scope"), @JoinColumn(referencedColumnName="identifier", name="identifier")})
    private Map<String, String> metaData = new HashMap<String, String>();
    @Lob
    private String policy;

    public boolean isScopeValid() {
        return this.scopeValid;
    }

    public InvalidPolicyException getInvalidPolicyException() {
        return this.invalidPolicyException;
    }

    public Policy() {
    }

    @Deprecated
    public Policy(PolicyId id, String policy) {
        this.id = id;
        this.policy = policy;
        this.validateXML();
        this.validateScope();
    }

    @Deprecated
    public Policy(PolicyId id, String policy, String description) {
        this.id = id;
        this.policy = policy;
        this.description = description;
        this.validateXML();
        this.validateScope();
    }

    public Policy(String policy) {
        this.policy = policy;
        this.validateXML();
        this.extractIdAndDescription();
        this.validateScope();
    }

    public boolean isXmlValid() {
        return this.xmlValid;
    }

    private boolean validateScope() {
        try {
            this.scopeValid = new PolicyValidator().checkPolicySolution(this);
        }
        catch (InvalidPolicyException e) {
            this.scopeValid = false;
            this.invalidPolicyException = e;
        }
        catch (Exception e) {
            LOG.warn("Exception in method validateScope", (Throwable)e);
        }
        return this.scopeValid;
    }

    public void extractIdAndDescription() {
        try {
            this.id = new PolicyId(this.readAttribute("//policy/@id"));
            this.description = this.readAttribute("//policy/@description");
        }
        catch (Exception e) {
            LOG.error("Exception in method extractIdAndDescription", (Throwable)e);
        }
    }

    public boolean validateXML() {
        try {
            this.xmlValid = new PolicyValidator().validateXMLSchema(this.policy);
        }
        catch (InvalidPolicyException e) {
            this.xmlValid = false;
            this.invalidPolicyException = e;
        }
        return this.xmlValid;
    }

    public Policy(String policy, String description) {
        this.policy = policy;
        this.description = description;
        this.validateXML();
        this.extractIdAndDescription();
        this.validateScope();
    }

    public void addMeta(String key, String value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, String>();
        }
        this.metaData.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Policy)) {
            return false;
        }
        Policy thePolicy = (Policy)o;
        return this.id != null ? this.id.equals(thePolicy.id) : thePolicy.id == null;
    }

    public String getDescription() {
        return this.description;
    }

    public PolicyId getId() {
        return this.id;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getPolicy() {
        return this.policy;
    }

    public PolicyType getType() {
        return this.id.getType();
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    private String readAttribute(String xpathString) {
        try {
            DocumentBuilderFactory documentumentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentumentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentumentBuilder = documentumentBuilderFactory.newDocumentBuilder();
            Document document = documentumentBuilder.parse(new InputSource(new StringReader(this.policy)));
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr = xpath.compile(xpathString);
            return (String)expr.evaluate(document, XPathConstants.STRING);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new IllegalArgumentException("Policy does not have attribute", e);
        }
    }

    public void setDeployed(boolean status) {
        this.deployed = status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(PolicyId id) {
        this.id = id;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }
}

