/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.DataObject;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterListProvider;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import org.slf4j.Logger;

public class PipRequest<T>
extends Ind2uceEntity
implements ParameterListProvider {
    private static final long serialVersionUID = 938365002647331506L;
    private static final Logger LOG = LoggerFactory.getLogger(PipRequest.class);
    private String name = null;
    private DataObject<T> defaultValue;
    private ParameterList parameters = new ParameterList();

    public PipRequest(String name, T defaultValue, Parameter<?> ... params) {
        this(name, defaultValue, new ParameterList(params));
    }

    public PipRequest(String name, T defaultValue, ParameterList params) {
        this.name = name;
        this.defaultValue = new DataObject<T>(defaultValue);
        if (params != null) {
            this.parameters = params;
        }
    }

    @Override
    public void addParameter(Parameter<?> param) {
        this.parameters.add(param);
    }

    public <R> void addParameter(String name, R value) {
        this.parameters.add(new Parameter<R>(name, value));
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipRequest)) {
            return false;
        }
        PipRequest pip2 = (PipRequest)obj;
        LOG.debug("Comparing pipRequest: " + this.getName());
        if (!this.name.equals(pip2.getName())) {
            return false;
        }
        LOG.debug("Comparing parameter: this:" + this.parameters.size() + "; other: " + pip2.parameters.size());
        if (this.parameters.size() != pip2.parameters.size()) {
            return false;
        }
        for (Parameter curParam : this.parameters) {
            try {
                if (curParam.equals(pip2.getParameterForName(curParam.getName()))) continue;
                LOG.debug("param " + curParam.getName() + " differ: [" + curParam.getValue() + "] vs. [" + pip2.getParameterForName(curParam.getName()).getValue() + "]");
                return false;
            }
            catch (NullPointerException e) {
                String msg = "Param: " + curParam.getName() + " is NOT present.";
                LOG.debug(msg);
                LOG.trace(msg, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public DataObject<?> getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Parameter<?> getParameterForName(String name) {
        return this.parameters.getParameterForName(name);
    }

    @Override
    public ParameterList getParameters() {
        return this.parameters;
    }

    public <R> R getParameterValue(String name, Class<R> clazz) {
        return this.parameters.getParameterValue(name, clazz);
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void setDefaultValue(DataObject<T> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameters(ParameterList params) {
        this.parameters.setParameters(params);
    }
}

