/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterListProvider;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ModifierEngine
extends Ind2uceEntity
implements ParameterListProvider {
    private static final long serialVersionUID = 4050073698831680651L;
    private String method;
    private final ParameterList parameters = new ParameterList();

    public ModifierEngine(String name) {
        this(name, null);
    }

    public ModifierEngine(String name, ParameterList params) {
        this.method = name;
        this.setParameters(params);
    }

    @Override
    public void addParameter(Parameter<?> param) {
        this.parameters.add(param);
    }

    @Override
    public <T> void addParameter(String name, T value) {
        this.parameters.add(new Parameter<T>(name, value));
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof ModifierEngine)) {
            return false;
        }
        ModifierEngine other = (ModifierEngine)obj;
        if (this.method == null && other.getMethod() != null) {
            return false;
        }
        return this.method.equals(other.getMethod());
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public Parameter<?> getParameterForName(String name) {
        return this.parameters.getParameterForName(name);
    }

    @Override
    public ParameterList getParameters() {
        return this.parameters;
    }

    @Override
    public <T> T getParameterValue(String name, Class<T> clazz) {
        return this.parameters.getParameterValue(name, clazz);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append(super.hashCode());
        builder.append((Object)this.getMethod());
        return builder.toHashCode();
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void setParameters(ParameterList params) {
        this.parameters.setParameters(params);
    }
}

