/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterListProvider;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;

public class ExecuteAction
extends Ind2uceEntity
implements ParameterListProvider {
    private static final long serialVersionUID = -8106817237376519851L;
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteAction.class);
    private ActionId id;
    private final ParameterList parameters = new ParameterList();

    public ExecuteAction() {
    }

    public ExecuteAction(ActionId actionId, ParameterList params) {
        this.id = actionId;
        this.setParameters(params);
    }

    public ExecuteAction(String actionId) {
        this(new ActionId(actionId), null);
    }

    @Override
    public void addParameter(Parameter<?> param) {
        this.parameters.add(param);
    }

    @Override
    public <T> void addParameter(String name, T value) {
        this.parameters.add(new Parameter<T>(name, value));
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteAction)) {
            return false;
        }
        ExecuteAction exec2 = (ExecuteAction)obj;
        LOG.debug("Comparing executeAction: " + this.getId());
        if (!this.id.equals(exec2.getId())) {
            return false;
        }
        if (this.parameters.size() != exec2.parameters.size()) {
            return false;
        }
        for (Parameter curParam : this.parameters) {
            LOG.debug("Comparing param: " + curParam.getName());
            if (curParam.equals(exec2.getParameterForName(curParam.getName()))) continue;
            LOG.debug("param " + curParam.getName() + " differ.");
            return false;
        }
        return true;
    }

    public ActionId getId() {
        return this.id;
    }

    @Override
    public Parameter<?> getParameterForName(String name) {
        return this.parameters.getParameterForName(name);
    }

    @Override
    public ParameterList getParameters() {
        return this.parameters;
    }

    @Override
    public <T> T getParameterValue(String name, Class<T> clazz) {
        return this.parameters.getParameterValue(name, clazz);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.id);
        for (Parameter p : this.parameters) {
            builder.append((Object)p.getName());
            builder.append(p.getValue());
        }
        return builder.toHashCode();
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void setId(ActionId id) {
        this.id = id;
    }

    @Override
    public void setParameters(ParameterList params) {
        this.parameters.setParameters(params);
    }
}

