/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterListProvider;

public class Event
extends Ind2uceEntity
implements ParameterListProvider {
    private static final long serialVersionUID = -1664098616473093266L;
    private ActionId actionId;
    private long timestamp;
    private transient Object tag;
    private ParameterList parameters = new ParameterList();

    public Event(ActionId actionId, boolean isTry, long time, Parameter<?> ... params) {
        this(actionId, isTry, time, new ParameterList(params));
    }

    public Event(ActionId actionId, boolean isTry, long time, ParameterList params) {
        if (actionId == null) {
            throw new IllegalArgumentException("ActionId may not be null");
        }
        this.actionId = actionId;
        this.timestamp = time;
        this.setParameters(params);
    }

    public Event(ActionId actionId, boolean isTry, Parameter<?> ... params) {
        this(actionId, isTry, System.currentTimeMillis(), params);
    }

    public Event(ActionId actionId, Parameter<?> ... params) {
        this(actionId, false, System.currentTimeMillis(), params);
    }

    @Override
    public void addParameter(Parameter<?> param) {
        if (this.parameters == null) {
            this.parameters = new ParameterList();
        }
        this.parameters.add(param);
    }

    @Override
    public <T> void addParameter(String name, T value) {
        if (this.parameters == null) {
            this.parameters = new ParameterList();
        }
        this.parameters.add(new Parameter<T>(name, value));
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    public ActionId getActionId() {
        return this.actionId;
    }

    public String getActionIdString() {
        return this.actionId.toString();
    }

    @Override
    public Parameter<?> getParameterForName(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.getParameterForName(name);
    }

    @Override
    public ParameterList getParameters() {
        return this.parameters;
    }

    @Override
    public <T> T getParameterValue(String name, Class<T> clazz) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.getParameterValue(name, clazz);
    }

    public Object getTag() {
        return this.tag;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValueForName(String name) {
        Parameter<?> param = this.getParameterForName(name);
        return param.getValue();
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(this.getParameterForName(name));
    }

    public void setActionId(ActionId actionId) {
        this.actionId = actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = new ActionId(actionId);
    }

    @Override
    public void setParameters(ParameterList params) {
        if (this.parameters == null) {
            this.parameters = new ParameterList();
        }
        this.parameters.setParameters(params);
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

