/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.policy;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.Modifier;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.DecisionId;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ModifierList;
import java.util.List;

public class AuthorizationDecision
extends Ind2uceEntity {
    private static final long serialVersionUID = -6800258958385977399L;
    public static final AuthorizationDecision DECISION_ALLOW = new AuthorizationDecision(new DecisionId("urn:decision:allow"), true);
    public static final AuthorizationDecision DECISION_INHIBIT = new AuthorizationDecision(new DecisionId("urn:decision:inhibit"), false);
    private DecisionId id;
    private boolean eventAllowed;
    private List<String> authorizationActionNames;
    private final ModifierList modifiers = new ModifierList();
    private long delay = 0L;

    public AuthorizationDecision() {
    }

    public AuthorizationDecision(AuthorizationDecision prototype) {
        this(prototype.getId(), prototype.isEventAllowed());
    }

    private AuthorizationDecision(DecisionId id, boolean allowEvent) {
        this(id, allowEvent, 0L, null, new Modifier[0]);
    }

    public AuthorizationDecision(DecisionId id, boolean eventAllowed, long delay, List<String> authorizationActionNames, Modifier ... modifiers) {
        this(id, eventAllowed, delay, authorizationActionNames, new ModifierList(modifiers));
    }

    public AuthorizationDecision(DecisionId id, boolean eventAllowed, long delay, List<String> authorizationActionNames, ModifierList modifiers) {
        this.id = id;
        this.eventAllowed = eventAllowed;
        if (authorizationActionNames != null) {
            this.setAuthorizationActionNames(authorizationActionNames);
        }
        if (eventAllowed) {
            this.setModifiers(modifiers);
            this.setDelay(delay);
        }
    }

    public static final AuthorizationDecision getDecisionAllow() {
        return new AuthorizationDecision(DECISION_ALLOW);
    }

    public static final AuthorizationDecision getDecisionInhibit() {
        return new AuthorizationDecision(DECISION_INHIBIT);
    }

    public void addModifier(Modifier param) {
        this.modifiers.add(param);
    }

    public void clearParameters() {
        this.modifiers.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizationDecision)) {
            return false;
        }
        AuthorizationDecision that = (AuthorizationDecision)o;
        if (this.eventAllowed != that.eventAllowed) {
            return false;
        }
        if (this.delay != that.delay) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.authorizationActionNames != null ? !this.authorizationActionNames.equals(that.authorizationActionNames) : that.authorizationActionNames != null) {
            return false;
        }
        return !(this.modifiers == null ? that.modifiers != null : !this.modifiers.equals(that.modifiers));
    }

    public List<String> getAuthorizationActionNames() {
        return this.authorizationActionNames;
    }

    public long getDelay() {
        return this.delay;
    }

    public DecisionId getId() {
        return this.id;
    }

    public Modifier getModifierForName(String name) {
        return this.modifiers.getParameterForName(name);
    }

    public ModifierList getModifiers() {
        return this.modifiers;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.eventAllowed ? 1 : 0);
        result = 31 * result + (this.authorizationActionNames != null ? this.authorizationActionNames.hashCode() : 0);
        result = 31 * result + (this.modifiers != null ? this.modifiers.hashCode() : 0);
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        return result;
    }

    public boolean isEventAllowed() {
        return this.eventAllowed;
    }

    public void removeParameter(String name) {
        this.modifiers.remove(name);
    }

    public void setAuthorizationActionNames(List<String> authorizationActionNames) {
        this.authorizationActionNames = authorizationActionNames;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setEventAllowed(boolean eventAllowed) {
        this.eventAllowed = eventAllowed;
    }

    public void setId(DecisionId id) {
        this.id = id;
    }

    public void setModifiers(ModifierList modifiers) {
        if (this.eventAllowed) {
            this.clearParameters();
            this.modifiers.addAll(modifiers);
        }
    }
}

