/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import java.util.regex.Pattern;

public class GroupId
extends Ind2uceEntity {
    private static final long serialVersionUID = 5971783346726612578L;
    public static final Pattern URN_GROUP_PATTERN = Pattern.compile("^urn:group(:[a-z0-9()+,\\-.=@;$_!*']+)+$", 2);
    private final String identifier;

    public GroupId(String urn) {
        this.validate(urn);
        this.identifier = urn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupId)) {
            return false;
        }
        GroupId groupId = (GroupId)o;
        return this.identifier != null ? this.identifier.equals(groupId.identifier) : groupId.identifier == null;
    }

    public String getId() {
        return this.toString();
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.identifier;
    }

    protected void validate(String uri) {
        URN_GROUP_PATTERN.matcher(uri).matches();
    }
}

