/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class EnforcementScopeTypeId
extends Ind2uceEntity {
    private static final long serialVersionUID = 5971783346726612578L;
    private static final Logger LOG = LoggerFactory.getLogger(EnforcementScopeTypeId.class);
    public static final Pattern URN_ES_TYPE_PATTERN = Pattern.compile("^urn:es-type:[a-z0-9()+,\\-.=@;$_!*']+$", 2);
    private final String identifier;

    public EnforcementScopeTypeId(String urn) {
        this.validate(urn);
        this.identifier = urn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnforcementScopeTypeId)) {
            return false;
        }
        EnforcementScopeTypeId that = (EnforcementScopeTypeId)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.identifier;
    }

    protected void validate(String uri) {
        URN_ES_TYPE_PATTERN.matcher(uri).matches();
    }
}

