/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import java.util.regex.Pattern;

public class EnforcementScopeId
extends Ind2uceEntity {
    private static final long serialVersionUID = 5971783346726612578L;
    public static final Pattern URN_ES_PATTERN = Pattern.compile("^urn:es:[a-z0-9()+,\\-.=@;$_!*']+$", 2);
    private final String identifier;

    public EnforcementScopeId(String urn) {
        if (urn == null) {
            throw new IllegalArgumentException("Illegal Enforcement Scope ID");
        }
        if (!urn.startsWith("urn:es:")) {
            urn = "urn:es:" + urn;
        }
        this.validate(urn);
        if (!URN_ES_PATTERN.matcher(urn).find()) {
            throw new IllegalArgumentException(urn);
        }
        String[] componentIdParts = urn.split(":");
        this.identifier = componentIdParts[2];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnforcementScopeId)) {
            return false;
        }
        EnforcementScopeId that = (EnforcementScopeId)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("urn:es:");
        s.append(this.identifier);
        return s.toString();
    }

    protected void validate(String uri) {
        URN_ES_PATTERN.matcher(uri).matches();
    }
}

