/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.ComponentType;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
public class ComponentId
extends Ind2uceEntity {
    private static final long serialVersionUID = 3233135419998235135L;
    public static final Pattern URN_COMPONENT_PATTERN = Pattern.compile("^urn:component:([a-z0-9()+,\\-.=@;$_!*'])+:(p[adeimrx]p|pmp_server):([a-z0-9()+,\\-.=@;$_!*']+|%[0-9a-f]{2})$", 2);
    @Column(name="component_type", length=20)
    @Enumerated(value=EnumType.STRING)
    private ComponentType componentType;
    @Column(name="identifier", length=70)
    private String identifier;
    @Column(name="scope", length=70)
    private String scope;

    public ComponentId() {
    }

    public ComponentId(ComponentType type) {
        this(("urn:component:scope:" + type.toString() + ":" + UUID.randomUUID().toString()).toLowerCase());
    }

    public ComponentId(String id) {
        this.validate(id);
        this.setAttributesByUrn(id, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentId)) {
            return false;
        }
        ComponentId that = (ComponentId)o;
        if (this.componentType != that.componentType) {
            return false;
        }
        return (this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null) && (this.scope != null ? this.scope.equals(that.scope) : that.scope == null);
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public String getId() {
        return this.toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getScope() {
        return this.scope;
    }

    public ComponentType getType() {
        return this.componentType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.componentType != null ? this.componentType.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        return result;
    }

    private void setAttributesByUrn(String urn, ComponentId instance) {
        String[] componentIdParts;
        if (URN_COMPONENT_PATTERN.matcher(urn).find()) {
            componentIdParts = urn.split(":");
            if (!componentIdParts[0].equalsIgnoreCase("urn")) {
                throw new IllegalArgumentException(urn);
            }
            if (!componentIdParts[1].equalsIgnoreCase("component")) {
                throw new IllegalArgumentException(urn);
            }
        } else {
            throw new IllegalArgumentException(urn);
        }
        instance.setScope(componentIdParts[2]);
        instance.setComponentType(ComponentType.valueOf(componentIdParts[3].toUpperCase()));
        instance.setIdentifier(componentIdParts[4]);
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("urn:component:");
        s.append(this.getScope());
        s.append(":");
        s.append(this.getType().name().toLowerCase());
        s.append(":");
        s.append(this.getIdentifier());
        return s.toString();
    }

    protected void validate(String uri) {
        URN_COMPONENT_PATTERN.matcher(uri).matches();
    }
}

