/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.description;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class TypeByName {
    private static final Logger LOG = LoggerFactory.getLogger(Ind2uceEntity.class);
    private static Map<String, Class<?>> primitivesByName = new HashMap();

    public static Class<?> getClassForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            LOG.trace("Class not known, getting primitive type", (Throwable)e);
            return primitivesByName.get(name);
        }
        catch (NullPointerException e) {
            LOG.trace("Primitive type not known, getting primitive type", (Throwable)e);
            return null;
        }
    }

    static {
        primitivesByName.put("byte", Byte.TYPE);
        primitivesByName.put("boolean", Boolean.TYPE);
        primitivesByName.put("char", Character.TYPE);
        primitivesByName.put("short", Short.TYPE);
        primitivesByName.put("int", Integer.TYPE);
        primitivesByName.put("long", Long.TYPE);
        primitivesByName.put("double", Double.TYPE);
        primitivesByName.put("float", Float.TYPE);
    }
}

