/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.description;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.description.InputParameterDescription;
import de.fraunhofer.iese.ind2uce.api.policy.identifier.ActionId;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
public class PepInterfaceDescription
extends Ind2uceEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    protected String description;
    @Embedded
    private ActionId event;
    private boolean isPreventive;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="interface_event_parameter_description_id")
    @Fetch(value=FetchMode.SUBSELECT)
    private List<InputParameterDescription> eventParameterDescription;

    public PepInterfaceDescription() {
    }

    public PepInterfaceDescription(ActionId event, boolean isPreventive, String description) {
        this(event, isPreventive, description, null);
    }

    public PepInterfaceDescription(ActionId event, boolean isPreventive, String description, List<InputParameterDescription> eventInputParameters) {
        this.description = description;
        this.event = event;
        this.isPreventive = isPreventive;
        this.eventParameterDescription = eventInputParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PepInterfaceDescription)) {
            return false;
        }
        PepInterfaceDescription that = (PepInterfaceDescription)o;
        if (this.isPreventive != that.isPreventive) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.event != null ? !this.event.equals(that.event) : that.event != null) {
            return false;
        }
        return this.eventParameterDescription != null ? this.eventParameterDescription.equals(that.eventParameterDescription) : that.eventParameterDescription == null;
    }

    public String getDescription() {
        return this.description;
    }

    public ActionId getEvent() {
        return this.event;
    }

    public List<InputParameterDescription> getEventParameterDescription() {
        return this.eventParameterDescription;
    }

    public Long getId() {
        return this.id;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
        result = 31 * result + (this.isPreventive ? 1 : 0);
        result = 31 * result + (this.eventParameterDescription != null ? this.eventParameterDescription.hashCode() : 0);
        return result;
    }

    public boolean isPreventive() {
        return this.isPreventive;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEvent(ActionId event) {
        this.event = event;
    }

    public void setEventParameterDescription(List<InputParameterDescription> eventParameterDescription) {
        this.eventParameterDescription = eventParameterDescription;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPreventive(boolean preventive) {
        this.isPreventive = preventive;
    }
}

