/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.description;

import com.google.common.base.Objects;
import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.description.InputParameterDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.Primitives;
import de.fraunhofer.iese.ind2uce.api.component.description.TypeByName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
public class MethodInterfaceDescription
extends Ind2uceEntity {
    private static final long serialVersionUID = 6925352815906821374L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    protected String description;
    protected String methodName;
    protected String returnType;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="interface_description_id")
    @Fetch(value=FetchMode.SUBSELECT)
    private List<InputParameterDescription> parameters = new ArrayList<InputParameterDescription>();

    MethodInterfaceDescription() {
    }

    public MethodInterfaceDescription(String methodName, Class<?> returnType, String description) {
        this(methodName, returnType, description, new ArrayList<InputParameterDescription>());
    }

    public MethodInterfaceDescription(String methodName, Class<?> returnType, String description, InputParameterDescription ... parameters) {
        this(methodName, returnType, description, new LinkedList<InputParameterDescription>(Arrays.asList(parameters)));
    }

    public MethodInterfaceDescription(String methodName, Class<?> returnType, String description, List<InputParameterDescription> parameters) {
        this.description = description;
        this.methodName = methodName;
        this.description = description;
        if (parameters != null) {
            this.parameters = parameters;
        } else {
            this.parameters.clear();
        }
        this.setReturnType(returnType);
    }

    public void addParameter(InputParameterDescription param) {
        this.parameters.add(param);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodInterfaceDescription) {
            MethodInterfaceDescription description = (MethodInterfaceDescription)obj;
            if (!Objects.equal(this.getReturnType(), description.getReturnType())) {
                return false;
            }
            if (!Objects.equal((Object)this.getMethodName(), (Object)description.getMethodName())) {
                return false;
            }
            if (!Objects.equal((Object)this.getDescription(), (Object)description.getDescription())) {
                return false;
            }
            return Objects.equal(this.parameters, description.getParameters());
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<InputParameterDescription> getParameters() {
        return this.parameters;
    }

    public Class<?> getReturnType() {
        return TypeByName.getClassForName(this.returnType);
    }

    public String getReturnTypeName() {
        return this.returnType;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.id);
        builder.append((Object)this.methodName);
        builder.append((Object)this.returnType);
        builder.append(this.parameters);
        builder.append((Object)this.description);
        return builder.toHashCode();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameters(List<InputParameterDescription> parameters) {
        this.parameters = parameters;
    }

    public void setReturnType(Class<?> returnType) {
        if (returnType != null) {
            Class<Object> wrappedType = Primitives.replaceByWrapper(returnType);
            if (wrappedType != null && Number.class.isAssignableFrom(wrappedType)) {
                wrappedType = Number.class;
                this.returnType = wrappedType.getCanonicalName();
            }
            this.returnType = returnType.getCanonicalName();
        }
    }
}

