/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component.description;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.description.JsonType;
import de.fraunhofer.iese.ind2uce.api.component.description.Primitives;
import de.fraunhofer.iese.ind2uce.api.component.description.TypeByName;
import de.fraunhofer.iese.ind2uce.api.component.description.TypeDescription;
import java.lang.reflect.Type;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
public class InputParameterDescription
extends Ind2uceEntity {
    private static final long serialVersionUID = -5113596900510393171L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String name;
    private String description;
    private String pattern;
    private String type;
    private JsonType jsonType;
    boolean mandatory = true;
    private String typeDescription;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TypeDescription> parameterTypeDescription;

    InputParameterDescription() {
    }

    public InputParameterDescription(String name, String description, Class<?> type) {
        this(name, description, null, true, type);
    }

    public InputParameterDescription(String name, String description, String pattern, boolean mandatory, Class<?> type) {
        this.name = name;
        this.description = description;
        this.pattern = pattern;
        this.mandatory = mandatory;
        this.setType(type);
    }

    public InputParameterDescription(String name, String description, String pattern, boolean mandatory, Type type) {
        this.name = name;
        this.description = description;
        this.pattern = pattern;
        this.mandatory = mandatory;
        this.type = type.toString();
    }

    public InputParameterDescription(String name, String description, String pattern, boolean mandatory, Type type, JsonType jsonType, List<TypeDescription> parameterTypeDescription) {
        this(name, description, pattern, mandatory, type);
        this.setJsonType(jsonType);
        this.parameterTypeDescription = parameterTypeDescription;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InputParameterDescription)) {
            return false;
        }
        InputParameterDescription other = (InputParameterDescription)obj;
        return this.name.equals(other.getName()) && this.type.equals(other.getTypeName());
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public JsonType getJsonType() {
        return this.jsonType;
    }

    public String getName() {
        return this.name;
    }

    public List<TypeDescription> getParameterTypeDescription() {
        return this.parameterTypeDescription;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Class<?> getType() {
        return TypeByName.getClassForName(this.type);
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public String getTypeName() {
        return this.type;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.name);
        builder.append((Object)this.type);
        return builder.toHashCode();
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setJsonType(JsonType jsonType) {
        this.jsonType = jsonType;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameterTypeDescription(List<TypeDescription> parameterTypeDescription) {
        this.parameterTypeDescription = parameterTypeDescription;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setType(Class<?> type) {
        Class<Object> wrappedType = Primitives.replaceByWrapper(type);
        if (wrappedType != null && Number.class.isAssignableFrom(wrappedType)) {
            wrappedType = Number.class;
        }
        this.type = wrappedType.getCanonicalName();
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }
}

