/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.ComponentType;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class ComponentBase
extends Ind2uceEntity {
    @EmbeddedId
    protected ComponentId id;
    @Lob
    @ElementCollection
    @CollectionTable(name="component_urls", joinColumns={@JoinColumn(referencedColumnName="component_type", name="component_type"), @JoinColumn(referencedColumnName="identifier", name="identifier"), @JoinColumn(referencedColumnName="scope", name="scope")})
    @Column(name="url")
    protected List<URI> urls;

    public ComponentBase() {
    }

    public ComponentBase(ComponentId cId) {
        this(cId, new ArrayList<URI>());
    }

    public ComponentBase(ComponentId cId, List<URI> urls) {
        if (cId == null) {
            throw new IllegalArgumentException("ComponentId may not be null");
        }
        this.id = cId;
        this.urls = urls;
    }

    public void addUrl(URI url) {
        if (null == url) {
            return;
        }
        if (this.urls == null) {
            this.urls = new ArrayList<URI>();
        }
        this.urls.add(url);
    }

    public ComponentId getId() {
        return this.id;
    }

    public ComponentType getType() {
        return this.id.getType();
    }

    public List<URI> getUrls() {
        return this.urls;
    }

    public List<URI> getUrlsForProtocol(String ... protocols) {
        if (protocols.length == 0) {
            return this.getUrls();
        }
        ArrayList<URI> result = new ArrayList<URI>();
        block0: for (URI url : this.urls) {
            for (String protocol : protocols) {
                if (!protocol.equals(url.getScheme())) continue;
                result.add(url);
                continue block0;
            }
        }
        return result;
    }

    public void setId(ComponentId id) {
        this.id = id;
    }

    public void setUrls(List<URI> urls) {
        this.urls = urls;
    }
}

