/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.component;

import de.fraunhofer.iese.ind2uce.api.component.ComponentBase;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
public class Component
extends ComponentBase {
    private static final long serialVersionUID = -4320938758386608680L;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumns(value={@JoinColumn(referencedColumnName="component_type", name="component_type"), @JoinColumn(referencedColumnName="identifier", name="identifier"), @JoinColumn(referencedColumnName="scope", name="scope")})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<MethodInterfaceDescription> componentInterfaces;

    Component() {
    }

    public Component(ComponentId id) {
        this(id, null, new MethodInterfaceDescription[0]);
    }

    public Component(ComponentId id, List<URI> urls, List<MethodInterfaceDescription> componentInterfaces) {
        super(id, urls);
        this.componentInterfaces = componentInterfaces;
    }

    public Component(ComponentId id, List<URI> urls, MethodInterfaceDescription ... componentInterface) {
        this(id, urls, Arrays.asList(componentInterface));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        if (this.id != null) {
            return this.id.equals(other.getId());
        }
        return super.equals(obj);
    }

    public List<MethodInterfaceDescription> getComponentInterfaces() {
        return this.componentInterfaces;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.id);
        return builder.toHashCode();
    }

    public void setComponentInterfaces(List<MethodInterfaceDescription> componentInterface) {
        this.componentInterfaces = componentInterface;
    }
}

