/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.api.common;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.fraunhofer.iese.ind2uce.api.common.Hide;
import de.fraunhofer.iese.ind2uce.api.common.RuntimeTypeAdapterFactory;
import de.fraunhofer.iese.ind2uce.api.component.description.ClassTypeDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.TypeDescription;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.DataObject;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public abstract class Ind2uceEntity
implements Serializable {
    private static List<String> unknownClasses = new ArrayList<String>();
    private static final Logger LOG = LoggerFactory.getLogger(Ind2uceEntity.class);
    private static final long serialVersionUID = 4880779801528117995L;
    private static final ExclusionStrategy HIDE_EXCLUSION = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            Hide hide = (Hide)fieldAttributes.getAnnotation(Hide.class);
            return hide != null;
        }
    };
    private static final JsonDeserializer<DataObject<?>> DATAOBJECT_DESERIALIZER = new JsonDeserializer<DataObject<?>>(){

        private DataObject<?> createObjectFromUnkownClass(JsonElement value, String type, boolean isComplex) {
            String result = !isComplex || isComplex && Object.class.getCanonicalName().equals(type) ? value.toString() : value.getAsString();
            DataObject<String> o = new DataObject<String>(result);
            o.setType(type);
            o.setComplex(true);
            return o;
        }

        public DataObject<?> deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) {
            JsonElement value = arg0.getAsJsonObject().get("value");
            String type = arg0.getAsJsonObject().get("type").getAsString();
            boolean isComplex = arg0.getAsJsonObject().get("isComplex").getAsBoolean();
            if (unknownClasses.contains(type)) {
                return this.createObjectFromUnkownClass(value, type, isComplex);
            }
            try {
                Object o = GSON_PLAIN.fromJson(value, Class.forName(type));
                return new DataObject<Object>(o, Class.forName(type));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Deserialization failed. Adding " + type + " to the list of unknown classes", (Throwable)e);
                unknownClasses.add(type);
                return this.createObjectFromUnkownClass(value, type, isComplex);
            }
        }
    };
    private static final JsonSerializer<DataObject<?>> DATAOBJECT_SERIALIZER = new JsonSerializer<DataObject<?>>(){

        public JsonElement serialize(DataObject<?> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("value", GSON_PLAIN.toJsonTree(src.getValue()));
            jsonObject.addProperty("type", src.getTypeName());
            jsonObject.addProperty("isComplex", Boolean.valueOf(src.isComplex()));
            return jsonObject;
        }
    };
    private static final JsonSerializer<TypeDescription> TYPE_DESCRIPTION_JSON_SERIALIZER = new JsonSerializer<TypeDescription>(){

        public JsonElement serialize(TypeDescription src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = (JsonObject)GSON_PLAIN.toJsonTree((Object)src);
            jsonObject.addProperty("type", src.getClass().getSimpleName());
            return jsonObject;
        }
    };
    private static final JsonDeserializer<TypeDescription> TYPE_DESCRIPTION_JSON_DESERIALIZER = new JsonDeserializer<TypeDescription>(){

        public TypeDescription deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String type;
                switch (type = json.getAsJsonObject().get("type").getAsString()) {
                    case "TypeDescription": {
                        return (TypeDescription)GSON_PLAIN.fromJson(json, TypeDescription.class);
                    }
                    case "ClassTypeDescription": {
                        return (TypeDescription)GSON_PLAIN.fromJson(json, ClassTypeDescription.class);
                    }
                }
                return null;
            }
            catch (Exception e) {
                LOG.debug("Using default GSON", (Throwable)e);
                return (TypeDescription)GSON_PLAIN.fromJson(json, TypeDescription.class);
            }
        }
    };
    private static final RuntimeTypeAdapterFactory<MethodInterfaceDescription> INTERFACE_DESCRIPTION_ADAPTER = RuntimeTypeAdapterFactory.of(MethodInterfaceDescription.class).registerSubtype(MethodInterfaceDescription.class);
    protected static final Gson GSON_PLAIN = new GsonBuilder().create();
    protected static final Gson GSON_DEFAULT = new GsonBuilder().addSerializationExclusionStrategy(HIDE_EXCLUSION).registerTypeAdapter(DataObject.class, DATAOBJECT_DESERIALIZER).registerTypeAdapter(DataObject.class, DATAOBJECT_SERIALIZER).registerTypeAdapter(TypeDescription.class, TYPE_DESCRIPTION_JSON_SERIALIZER).registerTypeAdapter(TypeDescription.class, TYPE_DESCRIPTION_JSON_DESERIALIZER).registerTypeAdapter(ClassTypeDescription.class, TYPE_DESCRIPTION_JSON_SERIALIZER).registerTypeAdapter(ClassTypeDescription.class, TYPE_DESCRIPTION_JSON_DESERIALIZER).registerTypeAdapterFactory(INTERFACE_DESCRIPTION_ADAPTER).create();
    protected static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().addSerializationExclusionStrategy(HIDE_EXCLUSION).registerTypeAdapter(DataObject.class, DATAOBJECT_DESERIALIZER).registerTypeAdapter(DataObject.class, DATAOBJECT_SERIALIZER).registerTypeAdapterFactory(INTERFACE_DESCRIPTION_ADAPTER).create();
    @Hide
    protected String version = this.getClass().getPackage().getImplementationVersion();

    public static <T extends Ind2uceEntity> T fromJson(String json, Class<T> clazz) {
        return (T)((Ind2uceEntity)GSON_PRETTY.fromJson(json, clazz));
    }

    public static Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().addSerializationExclusionStrategy(HIDE_EXCLUSION).registerTypeAdapter(DataObject.class, DATAOBJECT_DESERIALIZER).registerTypeAdapter(TypeDescription.class, TYPE_DESCRIPTION_JSON_SERIALIZER).registerTypeAdapter(TypeDescription.class, TYPE_DESCRIPTION_JSON_DESERIALIZER).registerTypeAdapter(ClassTypeDescription.class, TYPE_DESCRIPTION_JSON_SERIALIZER).registerTypeAdapter(ClassTypeDescription.class, TYPE_DESCRIPTION_JSON_DESERIALIZER).registerTypeAdapterFactory(INTERFACE_DESCRIPTION_ADAPTER).create();
    }

    public String getVersion() {
        return this.version;
    }

    public String toJson(boolean pretty) {
        if (pretty) {
            return GSON_PRETTY.toJson((Object)this);
        }
        return GSON_DEFAULT.toJson((Object)this);
    }

    public String toString() {
        return this.toJson(false);
    }
}

