/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.logger;

import de.fraunhofer.iese.ind2uce.logger.LoggerFactory.LogLevel;

import org.slf4j.Logger;
import org.slf4j.Marker;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * The Class SysoutLogger.
 */
public class SysoutLogger implements Logger {

  /**
   * The placeholder used by String.format.
   */
  private static final String STRING_FORMAT = "%s";

  /**
   * The placeholders used by logback.
   */
  private static final String REGEX = "\\{\\}";

  /**
   * The name of the logger.
   */
  private String name = "StandardOutLogger";

  /**
   * Instantiates a new sysout logger.
   */
  public SysoutLogger() {
  }

  /**
   * Instantiates a new sysout logger.
   *
   * @param name the name
   */
  public SysoutLogger(String name) {
    this.name = name;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(org.slf4j.Marker, java.lang.String)
   */
  @Override
  public void debug(Marker marker, String msg) {
    this.log(LogLevel.DEBUG, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(org.slf4j.Marker, java.lang.String,
   * java.lang.Object)
   */
  @Override
  public void debug(Marker marker, String format, Object arg) {
    this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));

  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(org.slf4j.Marker, java.lang.String,
   * java.lang.Object[])
   */
  @Override
  public void debug(Marker marker, String format, Object... arguments) {
    this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(org.slf4j.Marker, java.lang.String,
   * java.lang.Object, java.lang.Object)
   */
  @Override
  public void debug(Marker marker, String format, Object arg1, Object arg2) {
    this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(org.slf4j.Marker, java.lang.String,
   * java.lang.Throwable)
   */
  @Override
  public void debug(Marker marker, String msg, Throwable t) {
    this.debug(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(java.lang.String)
   */
  @Override
  public void debug(String msg) {
    this.log(LogLevel.DEBUG, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(java.lang.String, java.lang.Object)
   */
  @Override
  public void debug(String format, Object arg) {
    this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(java.lang.String, java.lang.Object[])
   */
  @Override
  public void debug(String format, Object... arguments) {
    this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(java.lang.String, java.lang.Object,
   * java.lang.Object)
   */
  @Override
  public void debug(String format, Object arg1, Object arg2) {
    this.debug(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#debug(java.lang.String, java.lang.Throwable)
   */
  @Override
  public void debug(String msg, Throwable t) {
    this.debug(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(org.slf4j.Marker, java.lang.String)
   */
  @Override
  public void error(Marker marker, String msg) {
    this.log(LogLevel.ERROR, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(org.slf4j.Marker, java.lang.String,
   * java.lang.Object)
   */
  @Override
  public void error(Marker marker, String format, Object arg) {
    this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));

  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(org.slf4j.Marker, java.lang.String,
   * java.lang.Object[])
   */
  @Override
  public void error(Marker marker, String format, Object... arguments) {
    this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(org.slf4j.Marker, java.lang.String,
   * java.lang.Object, java.lang.Object)
   */
  @Override
  public void error(Marker marker, String format, Object arg1, Object arg2) {
    this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(org.slf4j.Marker, java.lang.String,
   * java.lang.Throwable)
   */
  @Override
  public void error(Marker marker, String msg, Throwable t) {
    this.error(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(java.lang.String)
   */
  @Override
  public void error(String msg) {
    this.log(LogLevel.ERROR, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(java.lang.String, java.lang.Object)
   */
  @Override
  public void error(String format, Object arg) {
    this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(java.lang.String, java.lang.Object[])
   */
  @Override
  public void error(String format, Object... arguments) {
    this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(java.lang.String, java.lang.Object,
   * java.lang.Object)
   */
  @Override
  public void error(String format, Object arg1, Object arg2) {
    this.error(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#error(java.lang.String, java.lang.Throwable)
   */
  @Override
  public void error(String msg, Throwable t) {
    this.error(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#getName()
   */
  @Override
  public String getName() {
    return this.name;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(org.slf4j.Marker, java.lang.String)
   */
  @Override
  public void info(Marker marker, String msg) {
    this.log(LogLevel.INFO, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(org.slf4j.Marker, java.lang.String,
   * java.lang.Object)
   */
  @Override
  public void info(Marker marker, String format, Object arg) {
    this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));

  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(org.slf4j.Marker, java.lang.String,
   * java.lang.Object[])
   */
  @Override
  public void info(Marker marker, String format, Object... arguments) {
    this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(org.slf4j.Marker, java.lang.String,
   * java.lang.Object, java.lang.Object)
   */
  @Override
  public void info(Marker marker, String format, Object arg1, Object arg2) {
    this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(org.slf4j.Marker, java.lang.String,
   * java.lang.Throwable)
   */
  @Override
  public void info(Marker marker, String msg, Throwable t) {
    this.info(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(java.lang.String)
   */
  @Override
  public void info(String msg) {
    this.log(LogLevel.INFO, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(java.lang.String, java.lang.Object)
   */
  @Override
  public void info(String format, Object arg) {
    this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(java.lang.String, java.lang.Object[])
   */
  @Override
  public void info(String format, Object... arguments) {
    this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(java.lang.String, java.lang.Object,
   * java.lang.Object)
   */
  @Override
  public void info(String format, Object arg1, Object arg2) {
    this.info(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#info(java.lang.String, java.lang.Throwable)
   */
  @Override
  public void info(String msg, Throwable t) {
    this.info(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isDebugEnabled()
   */
  @Override
  public boolean isDebugEnabled() {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isDebugEnabled(org.slf4j.Marker)
   */
  @Override
  public boolean isDebugEnabled(Marker marker) {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isErrorEnabled()
   */
  @Override
  public boolean isErrorEnabled() {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isErrorEnabled(org.slf4j.Marker)
   */
  @Override
  public boolean isErrorEnabled(Marker marker) {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isInfoEnabled()
   */
  @Override
  public boolean isInfoEnabled() {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isInfoEnabled(org.slf4j.Marker)
   */
  @Override
  public boolean isInfoEnabled(Marker marker) {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isTraceEnabled()
   */
  @Override
  public boolean isTraceEnabled() {
    return true;
  }

  /**
   * (non-Javadoc)
   *
   * @see org.slf4j.Logger#isTraceEnabled(org.slf4j.Marker)
   */
  @Override
  public boolean isTraceEnabled(Marker marker) {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isWarnEnabled()
   */
  @Override
  public boolean isWarnEnabled() {
    return true;
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#isWarnEnabled(org.slf4j.Marker)
   */
  @Override
  public boolean isWarnEnabled(Marker marker) {
    return true;
  }

  /**
   * Log.
   *
   * @param level the level
   * @param msg the msg
   */
  public void log(LogLevel level, String msg) {
    final DateFormat dateFormat = new SimpleDateFormat("dd.MM.YYYY HH:mm:ss");
    final Date date = new Date();
    System.out.println("[" + dateFormat.format(date) + "][" + this.name + "][" + String.format("%5s", level) + "] " + msg);// NOSONAR
  }

  /**
   * Stack trace to string.
   *
   * @param e the exception or throwable
   * @return the stacktrace
   */
  private String stackTraceToString(Throwable e) {
    final StringWriter sw = new StringWriter();
    final PrintWriter pw = new PrintWriter(sw);
    e.printStackTrace(pw);
    return sw.toString();
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(org.slf4j.Marker, java.lang.String)
   */
  @Override
  public void trace(Marker marker, String msg) {
    this.log(LogLevel.TRACE, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(org.slf4j.Marker, java.lang.String,
   * java.lang.Object)
   */
  @Override
  public void trace(Marker marker, String format, Object arg) {
    this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));

  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(org.slf4j.Marker, java.lang.String,
   * java.lang.Object[])
   */
  @Override
  public void trace(Marker marker, String format, Object... arguments) {
    this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(org.slf4j.Marker, java.lang.String,
   * java.lang.Object, java.lang.Object)
   */
  @Override
  public void trace(Marker marker, String format, Object arg1, Object arg2) {
    this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(org.slf4j.Marker, java.lang.String,
   * java.lang.Throwable)
   */
  @Override
  public void trace(Marker marker, String msg, Throwable t) {
    this.trace(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(java.lang.String)
   */
  @Override
  public void trace(String msg) {
    this.log(LogLevel.TRACE, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(java.lang.String, java.lang.Object)
   */
  @Override
  public void trace(String format, Object arg) {
    this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(java.lang.String, java.lang.Object[])
   */
  @Override
  public void trace(String format, Object... arguments) {
    this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(java.lang.String, java.lang.Object,
   * java.lang.Object)
   */
  @Override
  public void trace(String format, Object arg1, Object arg2) {
    this.trace(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#trace(java.lang.String, java.lang.Throwable)
   */
  @Override
  public void trace(String msg, Throwable t) {
    this.trace(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(org.slf4j.Marker, java.lang.String)
   */
  @Override
  public void warn(Marker marker, String msg) {
    this.log(LogLevel.WARN, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(org.slf4j.Marker, java.lang.String,
   * java.lang.Object)
   */
  @Override
  public void warn(Marker marker, String format, Object arg) {
    this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));

  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(org.slf4j.Marker, java.lang.String,
   * java.lang.Object[])
   */
  @Override
  public void warn(Marker marker, String format, Object... arguments) {
    this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(org.slf4j.Marker, java.lang.String,
   * java.lang.Object, java.lang.Object)
   */
  @Override
  public void warn(Marker marker, String format, Object arg1, Object arg2) {
    this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(org.slf4j.Marker, java.lang.String,
   * java.lang.Throwable)
   */
  @Override
  public void warn(Marker marker, String msg, Throwable t) {
    this.warn(msg + "\n" + this.stackTraceToString(t));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(java.lang.String)
   */
  @Override
  public void warn(String msg) {
    this.log(LogLevel.WARN, msg);
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(java.lang.String, java.lang.Object)
   */
  @Override
  public void warn(String format, Object arg) {
    this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(java.lang.String, java.lang.Object[])
   */
  @Override
  public void warn(String format, Object... arguments) {
    this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arguments));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(java.lang.String, java.lang.Object,
   * java.lang.Object)
   */
  @Override
  public void warn(String format, Object arg1, Object arg2) {
    this.warn(String.format(format.replaceAll(REGEX, STRING_FORMAT), arg1, arg2));
  }

  /*
   * (non-Javadoc)
   * @see org.slf4j.Logger#warn(java.lang.String, java.lang.Throwable)
   */
  @Override
  public void warn(String msg, Throwable t) {
    this.warn(msg + "\n" + this.stackTraceToString(t));
  }
}
