/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2017 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.connectors;

import java.io.Serializable;
import java.net.URI;

/**
 * DTO to provide the infos to authenticate via OAuth.
 */
public class OAuthCredentials implements Authentication, Serializable {

  /**
   *
   */
  private static final long serialVersionUID = -5742179074145102251L;

  private String clientId;

  private String clientSecret;

  private URI accessTokenURI;

  public OAuthCredentials() {
  }

  public OAuthCredentials(String clientId, String clientSecret, URI accessTokenURI) {
    this.clientId = clientId;
    this.accessTokenURI = accessTokenURI;
    this.clientSecret = clientSecret;
  }

  @Override
  public Object getPrincipal() {
    return this.getClientId();
  }

  @Override
  public Object getCredentials() {
    return this.getClientSecret();
  }

  public String getClientId() {
    return this.clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public String getClientSecret() {
    return this.clientSecret;
  }

  public void setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
  }

  public URI getAccessTokenURI() {
    return this.accessTokenURI;
  }

  public void setAccessTokenURI(URI accessTokenURI) {
    this.accessTokenURI = accessTokenURI;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }

    final OAuthCredentials that = (OAuthCredentials)o;

    if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
      return false;
    }
    if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
      return false;
    }
    return this.accessTokenURI != null ? this.accessTokenURI.equals(that.accessTokenURI) : that.accessTokenURI == null;
  }

  @Override
  public int hashCode() {
    int result = this.clientId != null ? this.clientId.hashCode() : 0;
    result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
    result = 31 * result + (this.accessTokenURI != null ? this.accessTokenURI.hashCode() : 0);
    return result;
  }
}
