/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.policy.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;

/**
 * The Class MechanismId.
 */
public class MechanismId extends Ind2uceEntity {

  /**
   * The Constant serialVersionUID.
   */
  private static final long serialVersionUID = 3549884059463164585L;

  /**
   * The identifier.
   */
  private final String identifier;

  /**
   * Instantiates a new mechanism id.
   *
   * @param urn the urn
   */
  public MechanismId(String urn) {

    this.identifier = urn;
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MechanismId)) {
      return false;
    }

    final MechanismId that = (MechanismId)o;

    return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;

  }

  /**
   * Gets the id.
   *
   * @return the id
   */
  public String getId() {
    return this.toString();
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return this.identifier != null ? this.identifier.hashCode() : 0;
  }

  /*
   * (non-Javadoc)
   * @see de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity#toString()
   */
  @Override
  public String toString() {
    return this.identifier;
  }
}
